/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io.filefilter;

import com.jmorgan.io.filefilter.ExtensionFileFilter;
import com.jmorgan.io.filefilter.FileFilterAdapter;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;

public class MultiFileFilter
extends FileFilterAdapter {
    private ArrayList<Object> filters = new ArrayList();

    public MultiFileFilter() {
    }

    public MultiFileFilter(String[] filters) {
        this();
        int i = 0;
        while (i < filters.length) {
            this.filters.add(new ExtensionFileFilter(new String[]{filters[i]}));
            ++i;
        }
    }

    public MultiFileFilter(Collection<?> filterCollection) {
        this();
        if (filterCollection == null || filterCollection.size() == 0) {
            return;
        }
        for (Object filter : filterCollection) {
            if (!(filter instanceof FileFilter) && !(filter instanceof FilenameFilter)) continue;
            this.filters.add(filter);
        }
    }

    public MultiFileFilter(FileFilter[] filterArray) {
        this((Object[])filterArray);
    }

    public MultiFileFilter(FilenameFilter[] filterArray) {
        this((Object[])filterArray);
    }

    private MultiFileFilter(Object[] filterArray) {
        this();
        if (filterArray == null || filterArray.length == 0) {
            return;
        }
        int i = 0;
        while (i < filterArray.length) {
            this.filters.add(filterArray[i]);
            ++i;
        }
    }

    public void addFilter(FileFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Given filter cannot be null");
        }
        this.filters.add(filter);
    }

    public void addFilter(FilenameFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Given filter cannot be null");
        }
        this.filters.add(filter);
    }

    public void removeFilter(FileFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Given filter cannot be null");
        }
        this.filters.remove(filter);
    }

    public void removeFilter(FilenameFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Given filter cannot be null");
        }
        this.filters.remove(filter);
    }

    @Override
    public boolean accept(File pathname) {
        for (Object filter : this.filters) {
            if (filter instanceof FileFilter && ((FileFilter)filter).accept(pathname)) {
                return true;
            }
            if (!(filter instanceof FilenameFilter) || !((FilenameFilter)filter).accept(pathname, pathname.toString())) continue;
            return true;
        }
        return false;
    }
}

