/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class RegularExpressionFilter
implements FileFilter {
    private Pattern pattern;

    protected RegularExpressionFilter() throws NullPointerException {
    }

    public RegularExpressionFilter(Pattern pattern) {
        this.setPattern(pattern);
    }

    public RegularExpressionFilter(String regularExpression) throws NullPointerException {
        this.setPattern(regularExpression);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String regularExpression) throws NullPointerException {
        if (regularExpression == null) {
            throw new NullPointerException("regularExpression cannot be null");
        }
        this.pattern = Pattern.compile(regularExpression);
    }

    @Override
    public boolean accept(File pathname) {
        String fileName = pathname.getName();
        return this.pattern.matcher(fileName).matches();
    }
}

