/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.j2ee.xml;

import com.jmorgan.beans.util.BeanPropertyMap;
import com.jmorgan.j2ee.xml.XMLAttribute;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.util.StringUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class XMLBeanMap<T>
extends BeanPropertyMap<T> {
    private XMLElement rootNode;

    public XMLBeanMap(XMLElement rootNode, T bean) {
        this(rootNode, bean, false);
    }

    public XMLBeanMap(XMLElement rootNode, T bean, boolean debug) {
        super(bean, debug);
        this.setRootNode(rootNode);
        this.loadBean();
    }

    public XMLBeanMap(XMLElement rootNode, T bean, Map<String, String> defaultPropertyNameMap) {
        this(rootNode, bean, defaultPropertyNameMap, false);
    }

    public XMLBeanMap(XMLElement rootNode, T bean, Map<String, String> defaultPropertyNameMap, boolean debug) {
        super(bean, defaultPropertyNameMap, debug);
        this.setRootNode(rootNode);
        this.loadBean();
    }

    public XMLElement getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(XMLElement rootNode) {
        this.rootNode = rootNode;
    }

    @Override
    public Map<String, Object> getMap() {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        this.mapAttributes(this.rootNode, propertyMap);
        for (XMLElement node : this.rootNode.getNodes()) {
            this.mapAttributes(node, propertyMap);
            String parameter = node.getName();
            Object value = node.getValue();
            if (value == null && (value = node.getNodes()) instanceof ArrayList && ((ArrayList)value).size() == 0) {
                value = null;
            }
            if (this.isDebug()) {
                System.out.printf("XMLBeanMap.getMap(): [%s]=[%s]\r\n", parameter, String.valueOf(value));
            }
            propertyMap.put(parameter, value);
        }
        if (this.isDebug()) {
            System.out.printf("XMLBeanMap.getMap(): Property Map Size: %d\r\n", propertyMap.size());
        }
        return propertyMap;
    }

    @Override
    public boolean allowMap(String sourceProperty) {
        boolean allowMap = super.allowMap(sourceProperty);
        if (allowMap) {
            return allowMap;
        }
        if (sourceProperty.contains("-")) {
            String beanCompliantName = XMLBeanMap.convertToBeanCompliantPropertyName(sourceProperty);
            allowMap = super.allowMap(beanCompliantName);
        }
        return allowMap;
    }

    @Override
    public String getPropertyNameFor(String sourceProperty) {
        String newSourceProperty = super.getPropertyNameFor(sourceProperty);
        if (newSourceProperty.equals(sourceProperty) && StringUtility.containsAnyOf(sourceProperty, "-:")) {
            newSourceProperty = XMLBeanMap.convertToBeanCompliantPropertyName(sourceProperty);
        }
        return newSourceProperty;
    }

    private static String convertToBeanCompliantPropertyName(String sourceProperty) {
        StringBuilder fixedParameter = new StringBuilder();
        int lastChar = 44;
        char[] cArray = sourceProperty.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            int c = cArray[n2];
            if (c == 45 || c == 58) {
                lastChar = 45;
            } else {
                if (lastChar == 45) {
                    c = Character.toUpperCase((char)c);
                }
                fixedParameter.append((char)c);
                lastChar = c;
            }
            ++n2;
        }
        return fixedParameter.toString();
    }

    private void mapAttributes(XMLElement node, Map<String, Object> map) {
        Collection<XMLAttribute> attributes = node.getAttributes();
        for (XMLAttribute attribute : attributes) {
            if (!this.shouldMapAttribute(node, attribute)) continue;
            String attributeName = attribute.getName();
            String value = attribute.getValue();
            map.put(attributeName, value);
            if (!this.isDebug()) continue;
            System.out.printf("XMLBeanMap.mapAttributes(): Attribute [%s] with value [%s] of node [%s] is mapped.\r\n", attributeName, value, node.getName());
        }
    }

    protected boolean shouldMapAttribute(XMLElement node, XMLAttribute attribute) {
        return false;
    }
}

