/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.j2ee.xml;

import com.jmorgan.beans.JMBean;
import com.jmorgan.io.ASCFileReader;
import com.jmorgan.j2ee.xml.XMLAttribute;
import com.jmorgan.util.StringUtility;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLElement
extends JMBean
implements Cloneable {
    private static Exception parseException;
    private XMLElement parentNode;
    private ArrayList<XMLElement> childNodes;
    private ArrayList<XMLAttribute> attributes;
    private String name;
    private String value;
    private String namespacePrefix;
    private String namespaceURI;

    public static XMLElement parseXMLFile(String fileName) {
        return XMLElement.parseXMLFile(new File(fileName));
    }

    public static XMLElement parseXMLFile(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            ASCFileReader fileReader = new ASCFileReader(file);
            String xmlData = fileReader.readAll();
            return XMLElement.parseXMLString(xmlData);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static XMLElement parseXMLString(StringBuilder xmlString) {
        return XMLElement.parseXMLString(xmlString.toString());
    }

    public static XMLElement parseXMLString(String xmlString) {
        parseException = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(xmlString.getBytes("UTF-8")));
            XMLElement xmlElement = new XMLElement(doc);
            return xmlElement;
        }
        catch (ParserConfigurationException e) {
            parseException = e;
            e.printStackTrace();
        }
        catch (SAXException e) {
            parseException = e;
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            parseException = e;
            e.printStackTrace();
        }
        catch (IOException e) {
            parseException = e;
            e.printStackTrace();
        }
        return null;
    }

    public static Exception getParseException() {
        return parseException;
    }

    public XMLElement(String name) {
        this.setName(name);
        this.childNodes = new ArrayList();
    }

    public XMLElement(Node xmlNode) {
        this(xmlNode, null);
    }

    public XMLElement(Node xmlNode, XMLElement parentNode) {
        if (xmlNode == null) {
            return;
        }
        this.setParentNode(parentNode);
        this.setName(xmlNode.getNodeName());
        this.setValue(xmlNode.getNodeValue());
        this.setNamespacePrefix(xmlNode.getPrefix());
        this.setNamespaceURI(xmlNode.getNamespaceURI());
        this.childNodes = new ArrayList();
        NodeList nodeList = xmlNode.getChildNodes();
        if (nodeList == null) {
            return;
        }
        int nodeCount = nodeList.getLength();
        int i = 0;
        while (i < nodeCount) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                String nodeValue = node.getNodeValue();
                if (nodeValue != null) {
                    this.setValue(nodeValue);
                }
                if (this.getName().equals("content") && nodeValue == null) {
                    System.out.println("Content Node is Null");
                }
            } else {
                this.childNodes.add(new XMLElement(node, this));
            }
            ++i;
        }
        this.attributes = new ArrayList();
        NamedNodeMap attNodes = xmlNode.getAttributes();
        if (attNodes == null) {
            return;
        }
        int attCount = attNodes.getLength();
        int i2 = 0;
        while (i2 < attCount) {
            Node attribute = attNodes.item(i2);
            String attName = attribute.getNodeName();
            String attValue = attribute.getNodeValue();
            this.attributes.add(new XMLAttribute(attName, attValue));
            ++i2;
        }
    }

    public XMLElement(XMLElement element) {
        this.setName(element.name);
        this.setValue(element.value);
        this.setNamespacePrefix(element.namespacePrefix);
        this.setNamespaceURI(element.namespaceURI);
        this.setParentNode(element.parentNode);
        ArrayList<XMLElement> childNodes = new ArrayList<XMLElement>(element.childNodes.size());
        for (XMLElement cn : element.getNodes()) {
            try {
                childNodes.add((XMLElement)cn.clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        this.childNodes = childNodes;
        ArrayList<XMLAttribute> attributes = new ArrayList<XMLAttribute>(element.attributes.size());
        for (XMLAttribute att : element.getAttributes()) {
            try {
                attributes.add((XMLAttribute)att.clone());
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        this.attributes = attributes;
    }

    public Object clone() throws CloneNotSupportedException {
        return new XMLElement(this);
    }

    public XMLElement getRootNode() {
        XMLElement parent = this.getParentNode();
        while (parent != null) {
            parent = parent.getParentNode();
        }
        return parent;
    }

    public XMLElement getParentNode() {
        return this.parentNode;
    }

    public XMLElement getParentByName(String xmlElementName) {
        XMLElement parent = this.getParentNode();
        while (parent != null) {
            String name = parent.getName();
            if (name.matches(xmlElementName)) {
                return parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    public void setParentNode(XMLElement parentNode) {
        this.parentNode = parentNode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value == null || value.length() == 0 || value.length() == 1 && value.charAt(0) == '\n') {
            return;
        }
        this.value = value;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public boolean isEmpty() {
        return !(this.childNodes != null && this.childNodes.size() != 0 || this.value != null && this.value.length() != 0);
    }

    public XMLElement getNode(String nodeName) {
        Collection<XMLElement> nodes = this.getNodes(nodeName);
        if (nodes.size() == 0) {
            return null;
        }
        return nodes.iterator().next();
    }

    public Collection<XMLElement> getNodes() {
        return this.childNodes;
    }

    public Collection<XMLElement> getNodes(String searchExpression) {
        boolean recursiveSearch = false;
        if (searchExpression.startsWith("//")) {
            searchExpression = searchExpression.substring(2);
            recursiveSearch = true;
        }
        return this.getNodes(searchExpression, recursiveSearch);
    }

    private Collection<XMLElement> getNodes(String searchExpression, boolean isRecursive) {
        ArrayList<XMLElement> nodes = new ArrayList<XMLElement>();
        if (searchExpression.startsWith("/")) {
            searchExpression = searchExpression.substring(1);
        }
        int slashPos = searchExpression.indexOf(47);
        String searchPattern = null;
        String nextSearchPattern = null;
        if (slashPos == -1) {
            searchPattern = searchExpression;
        } else {
            searchPattern = StringUtility.getLeftSubstring(searchExpression, slashPos);
            nextSearchPattern = searchExpression.substring(slashPos);
        }
        Pattern pattern = Pattern.compile(searchPattern);
        for (XMLElement node : this.childNodes) {
            String nodeName = node.getName();
            Matcher matcher = pattern.matcher(nodeName);
            if (matcher.matches()) {
                if (nextSearchPattern == null) {
                    nodes.add(node);
                } else {
                    nodes.addAll(node.getNodes(nextSearchPattern, isRecursive));
                }
            }
            if (!isRecursive) continue;
            nodes.addAll(node.getNodes(searchExpression, isRecursive));
        }
        return nodes;
    }

    public void addAttribute(String attributeName, String attributeValue) {
        XMLAttribute attribute = new XMLAttribute(attributeName, attributeValue);
        this.addAttribute(attribute);
    }

    public void addAttribute(XMLAttribute attribute) {
        if (attribute == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(attribute);
    }

    public Collection<XMLAttribute> getAttributes() {
        return this.attributes;
    }

    public Collection<String> getAttributeNames() {
        ArrayList<String> attributeNames = new ArrayList<String>(this.attributes.size());
        for (XMLAttribute xmlAttribute : this.attributes) {
            attributeNames.add(xmlAttribute.getName());
        }
        return attributeNames;
    }

    public XMLAttribute getAttribute(String name) {
        if (this.attributes == null || this.attributes.size() == 0) {
            return null;
        }
        for (XMLAttribute a : this.attributes) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public String getAttributeValue(String attributeName) {
        for (XMLAttribute attribute : this.attributes) {
            if (!attribute.getName().equalsIgnoreCase(attributeName)) continue;
            return attribute.getValue();
        }
        return null;
    }

    public void removeAttribute(XMLAttribute attribute) {
        if (this.attributes == null || this.attributes.size() == 0) {
            return;
        }
        this.attributes.remove(attribute);
    }

    public void removeAttribute(String attributeName) {
        XMLAttribute attribute = this.getAttribute(attributeName);
        this.removeAttribute(attribute);
    }

    public void addNode(XMLElement node) {
        node.setParentNode(this);
        this.childNodes.add(node);
    }

    public void removeNode(XMLElement node) {
        this.childNodes.remove(node);
    }

    public void insertNodeBefore(XMLElement existingNode, XMLElement newNode) {
        int i = 0;
        while (i < this.childNodes.size()) {
            XMLElement node = this.childNodes.get(i);
            if (node == existingNode) {
                this.childNodes.add(i, newNode);
                break;
            }
            ++i;
        }
    }

    public void replaceNode(XMLElement oldNode, XMLElement newNode) {
        int i = 0;
        while (i < this.childNodes.size()) {
            XMLElement node = this.childNodes.get(i);
            if (node == oldNode) {
                newNode.setParentNode(oldNode.getParentNode());
                this.childNodes.set(i, newNode);
                break;
            }
            ++i;
        }
    }

    public int getHierarchyLevel() {
        int level = 0;
        XMLElement parent = this.getParentNode();
        while (parent != null) {
            ++level;
            parent = parent.getParentNode();
        }
        return level;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.namespacePrefix, this.namespaceURI, this.value, this.attributes, this.getNodes());
    }

    public boolean equals(Object o) {
        return this.equals(o, "name", "namespacePrefix", "namespaceURI", "value", "attributes", "nodes");
    }

    @Override
    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeLocalTag, boolean ignoreHierarchy) {
        StringBuilder sb = new StringBuilder();
        int hierarchyLevel = this.getHierarchyLevel();
        if (ignoreHierarchy) {
            hierarchyLevel = 0;
        }
        String depthTabs = "\t".repeat(hierarchyLevel);
        if (includeLocalTag) {
            if (this.parentNode == null) {
                sb.append("<?xml version=\"1.0\"?>\r\n");
            }
            sb.append(depthTabs);
            sb.append("<");
            if (this.namespacePrefix != null && !this.name.startsWith(this.namespacePrefix)) {
                sb.append(this.namespacePrefix);
                sb.append(":");
            }
            sb.append(this.name);
            if (this.attributes != null && this.attributes.size() > 0) {
                sb.append(" ");
                for (XMLAttribute attribute : this.attributes) {
                    sb.append(attribute);
                    sb.append(" ");
                }
            }
            if (this.namespaceURI != null) {
                sb.append(" xmlns");
                if (this.namespacePrefix != null) {
                    sb.append(":");
                    sb.append(this.namespacePrefix);
                }
                sb.append("=\"");
                sb.append(this.namespaceURI);
                sb.append("\"");
            }
            if (this.value == null && (this.childNodes == null || this.childNodes.size() == 0)) {
                sb.append("/");
            }
            sb.append(">");
        }
        if (this.value != null) {
            String newValue = XMLElement.escapeAmpersands(this.value);
            sb.append(newValue);
        } else {
            sb.append("\n");
        }
        for (XMLElement element : this.childNodes) {
            sb.append(element.toString(includeLocalTag, ignoreHierarchy));
            sb.append("\n");
        }
        if (includeLocalTag && (this.value != null || this.childNodes != null && this.childNodes.size() > 0)) {
            if (this.childNodes != null && this.childNodes.size() > 0) {
                sb.append(depthTabs);
            }
            sb.append("</");
            if (this.namespacePrefix != null && !this.name.startsWith(this.namespacePrefix)) {
                sb.append(this.namespacePrefix);
                sb.append(":");
            }
            sb.append(this.name);
            sb.append(">\n");
        }
        if (ignoreHierarchy) {
            return sb.toString().trim();
        }
        return sb.toString();
    }

    private static String escapeAmpersands(String value) {
        if (value.contains("&")) {
            value = value.replaceAll("&(?!(amp;))", "&amp;");
        }
        return value;
    }
}

