/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.ApplicationParameters;
import com.jmorgan.beans.util.BeanPropertyLoader;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.io.ApplicationPropertiesBeanMap;
import com.jmorgan.lang.ApplicationProperties;
import com.jmorgan.lang.ApplicationServices;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.AttributeChangeListener;
import com.jmorgan.lang.ClassPath;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.jmorgan.util.logging.MessageFilter;
import com.jmorgan.util.logging.StandardConsoleHandler;
import com.jmorgan.util.logging.StandardLogFormatter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Application {
    public static final String PROPERTIES_FILE_NAME = "Application.propertiesFileName";
    public static final String PROPERTIES = "Application.properties";
    public static final String CLASSPATH = "Application.classpath";
    public static final String LOCALE = "Application.locale";
    public static final String PROGRAM_PARAMETERS = "Application.programArgs";
    public static final String DATA_CACHE = "Application.dataCache";
    private static final String ALL_ATTRIBUTES_KEY = new String("{-{-{all attributes}-}-}");
    private static Application application;
    private Logger log;
    private StandardConsoleHandler consoleHandler;
    private StandardConsoleHandler errHandler;
    private FileHandler appFileHandler;
    private Level applicationLogLevel;
    private String logFilter;
    public ApplicationParameters applicationParameters;
    private ApplicationProperties applicationProperties;
    private ApplicationServices applicationServices;
    private ConcurrentHashMap<Object, Object> attributes;
    private HashMap<Object, ArrayList<AttributeChangeListener>> attributeChangeListeners;
    private int lastAttributesSize = Integer.MIN_VALUE;

    public static Application getApplication() {
        return application;
    }

    protected Application(String[] args) {
        Application.createStartupLog();
        this.applicationServices = this.getApplicationServices();
        this.attributes = new ConcurrentHashMap();
        this.attributeChangeListeners = new HashMap();
        this.attributes.put(CLASSPATH, new ClassPath());
        this.attributes.put(LOCALE, Locale.getDefault());
        String propertiesFileName = this.getPropertiesFileName();
        if (propertiesFileName != null) {
            this.loadProperties(propertiesFileName, this.getApplicationProperties());
        }
        application = this;
        this.applicationLogLevel = Level.CONFIG;
        this.attributes.put(PROGRAM_PARAMETERS, args);
        this.processArguments(args);
        this.setApplicationLogging();
        new AsynchMethodInvoker((Object)this, "checkAttributes", 1000);
    }

    @Reflected
    private static void createStartupLog() {
        Properties properties = System.getProperties();
        Date now = new Date();
        String title = String.format("Last Run: %s\n\n", now.toString());
        StringBuilder outputText = new StringBuilder(title);
        outputText.append("\n\n");
        outputText.append("=".repeat(80));
        outputText.append("\nSystem Information\n");
        outputText.append("=".repeat(80));
        outputText.append("\n\n");
        ArrayList<String> propertyNames = new ArrayList<String>(properties.size());
        for (Object propertyKeyName : properties.keySet()) {
            propertyNames.add(propertyKeyName.toString());
        }
        Collections.sort(propertyNames);
        String classPath = null;
        for (String propertyName : propertyNames) {
            String propertyValue = properties.getProperty(propertyName.toString());
            if (propertyName.equals("user.dir")) {
                classPath = propertyValue;
            }
            String property = String.format("%s - %s\n", propertyName, propertyValue);
            outputText.append(property);
        }
        outputText.append("\n\n");
        try {
            String startupFileName = String.format("%sStartup.log", classPath);
            new ASCFileWriter(startupFileName, outputText.toString(), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ConcurrentHashMap<Object, Object> getAttributes() {
        Application.getApplication().getApplicationLogger().finer("() Starting");
        return this.attributes;
    }

    public String[] getArguments() {
        return (String[])this.getAttribute(PROGRAM_PARAMETERS);
    }

    protected void processArguments(String[] args) {
        this.applicationParameters = this.getApplicationParametersBean();
        if (this.applicationParameters == null) {
            return;
        }
        Application.mapProgramParametersToBean(args, this.applicationParameters);
        this.logFilter = this.applicationParameters.getLogFilter();
        String logLevel = this.applicationParameters.getLogLevel();
        if (logLevel == null) {
            return;
        }
        switch (logLevel.toLowerCase()) {
            case "off": 
            case "none": {
                this.applicationLogLevel = Level.OFF;
                break;
            }
            case "severe": {
                this.applicationLogLevel = Level.SEVERE;
                break;
            }
            case "warning": {
                this.applicationLogLevel = Level.WARNING;
                break;
            }
            case "info": {
                this.applicationLogLevel = Level.INFO;
                break;
            }
            case "config": {
                this.applicationLogLevel = Level.CONFIG;
                break;
            }
            case "fine": {
                this.applicationLogLevel = Level.FINE;
                break;
            }
            case "finer": {
                this.applicationLogLevel = Level.FINER;
                break;
            }
            case "finest": {
                this.applicationLogLevel = Level.FINEST;
                break;
            }
            case "all": {
                this.applicationLogLevel = Level.ALL;
            }
        }
    }

    public <BeanType extends ApplicationParameters> BeanType getApplicationParametersBean() {
        if (this.applicationParameters == null) {
            return (BeanType)new ApplicationParameters();
        }
        return (BeanType)this.applicationParameters;
    }

    protected static <BeanType extends ApplicationParameters> void mapProgramParametersToBean(String[] args, BeanType pojo) {
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String[] nv = arg.split("=");
            if (BeanService.hasProperty(pojo, nv[0])) {
                switch (nv.length) {
                    case 1: {
                        argMap.put(nv[0], true);
                        break;
                    }
                    case 2: {
                        argMap.put(nv[0], nv[1]);
                    }
                }
            }
            ++n2;
        }
        new BeanPropertyLoader(pojo, argMap);
    }

    public String getPropertiesFileName() {
        String className = this.getClass().getSimpleName();
        String propertiesFileName = className + ".properties";
        File propertiesFile = new File(propertiesFileName);
        if (propertiesFile.exists()) {
            return className;
        }
        System.out.println("Application.getPropertiesFileName(): You must override to provide the proper name for the application's properties file.");
        return null;
    }

    public final ApplicationProperties getApplicationProperties() {
        if (this.applicationProperties == null) {
            this.applicationProperties = this.createApplicationPropertiesObject();
        }
        return this.applicationProperties;
    }

    public final void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        this.attributes.put(PROPERTIES, applicationProperties);
    }

    protected ApplicationProperties createApplicationPropertiesObject() {
        return this.createApplicationPropertiesObject(true);
    }

    protected ApplicationProperties createApplicationPropertiesObject(boolean supplyDefaultOnFailure) {
        Pair<String, String> packageAndClass = this.getPackageAndClass();
        String appPropertiesClass = (String)packageAndClass.first + ".app." + (String)packageAndClass.second + "ApplicationProperties";
        ApplicationProperties applicationProperties = null;
        try {
            applicationProperties = (ApplicationProperties)BeanService.getBean(appPropertiesClass);
            return applicationProperties;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (supplyDefaultOnFailure) {
            System.out.printf("Application.createApplicationPropertiesObject(supplyDefaultOnFailure=%b): Could not find custom application properties object %s.  Using default application properties object.", supplyDefaultOnFailure, appPropertiesClass);
            return new ApplicationProperties();
        }
        System.err.printf("Application.createApplicationPropertiesObject(supplyDefaultOnFailure=%b): Could not find custom application properties object %s.  Not using Properties.", supplyDefaultOnFailure, appPropertiesClass);
        return null;
    }

    protected Pair<String, String> getPackageAndClass() {
        String appClassName = this.getClass().getName();
        int lastDot = appClassName.lastIndexOf(46);
        String className = appClassName.substring(lastDot + 1);
        int prevDot = appClassName.lastIndexOf(46, lastDot - 1);
        if (prevDot == -1) {
            prevDot = lastDot;
        }
        String packageName = StringUtility.getLeftSubstring(appClassName, prevDot);
        return new Pair<String, String>(packageName, className);
    }

    public void setAttribute(Object attributeKey, Object attribute) {
        if (this.attributes.containsKey(attributeKey)) {
            Object oldValue = this.attributes.get(attributeKey);
            this.attributes.put(attributeKey, attribute);
            for (AttributeChangeListener listener : this.getInterestedListeners(attributeKey)) {
                listener.attributeChanged(attributeKey, oldValue, attribute);
            }
        } else {
            this.attributes.put(attributeKey, attribute);
            for (AttributeChangeListener listener : this.getInterestedListeners(attributeKey)) {
                listener.attributeAdded(attributeKey, attribute);
            }
        }
    }

    public Object getAttribute(Object attributeKey) {
        Object attributeValue = this.attributes.get(attributeKey);
        return attributeValue;
    }

    @Reflected
    private void checkAttributes() {
        Application.getApplication().getApplicationLogger().finer("(): *** Starting");
        int keyCount = ((ConcurrentHashMap.CollectionView)((Object)this.attributes.keySet())).size();
        if (keyCount != this.lastAttributesSize) {
            String thisApp = Application.getApplication().getClass().getSimpleName() + " - " + this.toString();
            String thisAttributes = this.attributes.toString();
            Application.getApplication().getApplicationLogger().finest(() -> LMG.log("app=%s, attributes=%s ():  Attributes Changed.  Checking %d attributes.", () -> thisApp, () -> thisAttributes, () -> keyCount));
            if (keyCount > 0) {
                for (Object attributeKey : this.attributes.keySet()) {
                    Object value = this.attributes.get(attributeKey);
                    if (value == null) {
                        Application.getApplication().getApplicationLogger().finest(() -> LMG.log("app=%s, attributes=%s ():  %s:  VALUE IS NULL", () -> thisApp, () -> thisAttributes, () -> String.valueOf(attributeKey)));
                        continue;
                    }
                    Application.getApplication().getApplicationLogger().finest(() -> LMG.log("app=%s, attributes=%s ():  %s:  Value exists.", () -> thisApp, () -> thisAttributes, () -> String.valueOf(attributeKey)));
                }
            }
            Application.getApplication().getApplicationLogger().finer("(): *** DONE");
            this.lastAttributesSize = keyCount;
        }
    }

    public Object removeAttribute(Object attributeKey) {
        Object attribute = null;
        if (this.attributes.containsKey(attributeKey)) {
            attribute = this.attributes.remove(attributeKey);
            for (AttributeChangeListener listener : this.getInterestedListeners(attributeKey)) {
                listener.attributeRemoved(attributeKey, attribute);
            }
        }
        return attribute;
    }

    private ArrayList<AttributeChangeListener> getInterestedListeners(Object key) {
        ArrayList<AttributeChangeListener> allListeners = this.attributeChangeListeners.get(ALL_ATTRIBUTES_KEY);
        if (!key.equals(ALL_ATTRIBUTES_KEY)) {
            if (allListeners == null) {
                allListeners = this.attributeChangeListeners.get(key);
            } else {
                ArrayList<AttributeChangeListener> keyListeners = this.attributeChangeListeners.get(key);
                if (keyListeners != null) {
                    allListeners.addAll(keyListeners);
                }
            }
        }
        if (allListeners == null) {
            allListeners = new ArrayList();
        }
        return allListeners;
    }

    public ClassPath getClassPath() {
        ClassPath classPath = (ClassPath)this.attributes.get(CLASSPATH);
        return classPath;
    }

    public void addAttributeChangeListener(AttributeChangeListener listener) {
        this.addAttributeChangeListener(ALL_ATTRIBUTES_KEY, listener);
    }

    public void addAttributeChangeListener(Object key, AttributeChangeListener listener) {
        ArrayList<AttributeChangeListener> listeners = this.attributeChangeListeners.get(key);
        if (listeners == null) {
            listeners = new ArrayList();
            this.attributeChangeListeners.put(key, listeners);
        }
        listeners.add(listener);
    }

    public void removeAttributeChangeListener(AttributeChangeListener listener) {
        this.removeAttributeChangeListener(ALL_ATTRIBUTES_KEY, listener);
    }

    public void removeAttributeChangeListener(Object key, AttributeChangeListener listener) {
        ArrayList<AttributeChangeListener> listeners = this.attributeChangeListeners.get(key);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
    }

    public void loadProperties(String propertiesFileName, ApplicationProperties applicationProperties) {
        if (propertiesFileName == null) {
            return;
        }
        if (!((String)propertiesFileName).endsWith(".properties")) {
            propertiesFileName = (String)propertiesFileName + ".properties";
        }
        this.attributes.put(PROPERTIES_FILE_NAME, propertiesFileName);
        new ApplicationPropertiesBeanMap((String)propertiesFileName, applicationProperties);
        this.setApplicationProperties(applicationProperties);
    }

    public String getApplicationLogFileName() {
        return String.format("%s%%u.log%%g", this.getClass().getSimpleName());
    }

    public Logger getApplicationLogger() {
        return this.log;
    }

    public void setApplicationLogging() {
        this.setApplicationLogging(null);
    }

    public void setApplicationLogging(String appLogFile) {
        this.log = Logger.getLogger(this.getClass().getName());
        this.log.setLevel(this.applicationLogLevel);
        if (StringUtility.isNotEmpty(this.logFilter)) {
            MessageFilter messageFilter = new MessageFilter(this.logFilter);
            this.log.setFilter(messageFilter);
        }
        StandardLogFormatter formatter = new StandardLogFormatter();
        this.createConsoleHandler(formatter);
        if (appLogFile == null) {
            appLogFile = this.getApplicationLogFileName();
        }
        try {
            this.appFileHandler = new FileHandler(appLogFile, 10000000, 10);
            this.appFileHandler.setLevel(this.applicationLogLevel);
            this.appFileHandler.setFormatter(formatter);
            this.log.addHandler(this.appFileHandler);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createConsoleHandler(StandardLogFormatter formatter) {
        if (this.createConsoleLogHandler()) {
            this.consoleHandler = new StandardConsoleHandler();
            this.consoleHandler.setMinLevel(this.getDefaultConsoleMinimumLogLevel());
            this.consoleHandler.setMaxLevel(this.getDefaultConsoleMaximumLogLevel());
            this.consoleHandler.setFormatter(formatter);
            this.log.addHandler(this.consoleHandler);
        }
        if (this.createErrorLogHandler()) {
            this.errHandler = new StandardConsoleHandler(1);
            this.errHandler.setMinLevel(this.getDefaultErrorMinimumLogLevel());
            this.errHandler.setMaxLevel(this.getDefaultErrorMaximumLogLevel());
            this.errHandler.setFormatter(formatter);
            this.log.addHandler(this.errHandler);
        }
    }

    protected boolean createConsoleLogHandler() {
        return true;
    }

    protected boolean createErrorLogHandler() {
        return true;
    }

    protected Level getDefaultConsoleMinimumLogLevel() {
        return Level.FINER;
    }

    protected Level getDefaultConsoleMaximumLogLevel() {
        return Level.CONFIG;
    }

    protected Level getDefaultErrorMinimumLogLevel() {
        return Level.INFO;
    }

    protected Level getDefaultErrorMaximumLogLevel() {
        return Level.SEVERE;
    }

    public void setApplicationLogLevel(Level logLevel) {
        this.appFileHandler.setLevel(logLevel);
        if (this.consoleHandler != null) {
            this.consoleHandler.setMinLevel(logLevel);
        }
        if (this.errHandler != null && this.errHandler.getMinLevel().intValue() < logLevel.intValue()) {
            this.errHandler.setMinLevel(logLevel);
        }
    }

    public void closeApplicationLogging() {
        Handler[] handlers;
        Handler[] handlerArray = handlers = this.log.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler instanceof FileHandler) {
                handler.close();
            }
            ++n2;
        }
    }

    protected ApplicationServices createApplicationServicesObject() {
        return null;
    }

    public ApplicationServices getApplicationServices() {
        if (this.applicationServices == null) {
            this.applicationServices = this.createApplicationServicesObject();
        }
        return this.applicationServices;
    }

    public void setApplicationServices(ApplicationServices applicationServices) {
        this.applicationServices = applicationServices;
    }
}

