/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import com.jmorgan.beans.JMBean;
import com.jmorgan.util.comparator.CollectionComparator;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;

public class ClassPath
extends JMBean
implements Comparable<ClassPath> {
    private String systemProperty;
    private ArrayList<String> entries;

    public ClassPath() {
        this("java.class.path");
    }

    public ClassPath(String systemProperty) {
        this.setSystemProperty(systemProperty);
    }

    public String getSystemProperty() {
        return this.systemProperty;
    }

    private void setSystemProperty(String systemProperty) {
        this.systemProperty = systemProperty;
        this.entries = null;
        String classPath = System.getProperty(systemProperty);
        String[] entries = classPath.split("[;:]");
        if (entries.length == 0) {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            URL[] urls = ((URLClassLoader)cl).getURLs();
            this.entries = new ArrayList();
            URL[] uRLArray = urls;
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                this.entries.add(url.getFile());
                ++n2;
            }
        } else {
            this.setEntries(new ArrayList<String>(Arrays.asList(entries)));
        }
    }

    public ArrayList<String> getEntries() {
        return this.entries;
    }

    private void setEntries(ArrayList<String> entries) {
        this.entries = entries;
    }

    @Override
    public int compareTo(ClassPath that) {
        if (that == null) {
            return 1;
        }
        if (this.equals(that)) {
            return 0;
        }
        int cmp = this.systemProperty.compareTo(that.systemProperty);
        if (cmp != 0) {
            return cmp;
        }
        return new CollectionComparator<String>().compare(this.entries, that.entries);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof ClassPath) {
            ClassPath that = (ClassPath)o;
            return this.areEqual(this.systemProperty, that.systemProperty) && this.areEqual(this.entries, that.entries);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.systemProperty);
        sb.append(":\n\t");
        for (String entry : this.entries) {
            sb.append(entry);
            sb.append("\n\t");
        }
        return sb.toString();
    }
}

