/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import com.jmorgan.lang.MethodInvoker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class DynamicProcess {
    private ArrayList<MethodInvoker<?>> processMethods = new ArrayList();
    private ArrayList<Object> returnValues;

    public DynamicProcess() {
    }

    public DynamicProcess(MethodInvoker<?> ... methods) {
        this();
        MethodInvoker<?>[] methodInvokerArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodInvoker<?> methodInvoker = methodInvokerArray[n2];
            this.addProcessMethod(methodInvoker);
            ++n2;
        }
    }

    public void addProcessMethod(MethodInvoker<?> methodInvoker) {
        if (methodInvoker == null) {
            return;
        }
        this.processMethods.add(methodInvoker);
    }

    public void removeProcessMethod(MethodInvoker<?> methodInvoker) {
        if (methodInvoker == null) {
            return;
        }
        this.processMethods.remove(methodInvoker);
    }

    public void clearProcess() {
        this.processMethods.clear();
    }

    public ArrayList<MethodInvoker<?>> getProcessMethods() {
        return this.processMethods;
    }

    public void setProcessMethods(ArrayList<MethodInvoker<?>> processMethods) {
        if (this.processMethods != null) {
            this.processMethods.clear();
        }
        this.processMethods = processMethods;
    }

    public Object[] getProcessArguments() {
        ArrayList<Object> processArgs = new ArrayList<Object>();
        for (MethodInvoker<?> invoker : this.processMethods) {
            Object[] args = invoker.getArguments();
            if (args == null || args.length <= 0) continue;
            processArgs.addAll(Arrays.asList(args));
        }
        return processArgs.toArray();
    }

    public void setProcessArguments(Object ... processArguments) {
        int processArgumentIndex = 0;
        for (MethodInvoker<?> invoker : this.processMethods) {
            Object[] methodArguments = invoker.getArguments();
            if (methodArguments == null || methodArguments.length <= 0) continue;
            int i = 0;
            while (i < methodArguments.length) {
                if (processArgumentIndex >= processArguments.length) break;
                methodArguments[i] = processArguments[processArgumentIndex];
                ++i;
                ++processArgumentIndex;
            }
            if (processArgumentIndex >= processArguments.length) break;
            invoker.setArguments(methodArguments);
        }
    }

    public ArrayList<Object> getReturnValues() {
        return this.returnValues;
    }

    public void setReturnValues(ArrayList<Object> returnValues) {
        this.returnValues = returnValues;
    }

    public Collection<?> invoke() {
        this.returnValues = new ArrayList();
        for (MethodInvoker<?> methodInvoker : this.processMethods) {
            this.returnValues.add(methodInvoker.invoke());
        }
        return this.returnValues;
    }
}

