/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import com.jmorgan.lang.ExceptionEvent;
import com.jmorgan.lang.ExceptionListener;
import com.jmorgan.lang.ExceptionListenerSupport;
import java.util.Collection;
import java.util.HashMap;

public class ExceptionListenerSupporter
implements ExceptionListenerSupport {
    private HashMap<ExceptionListener, ExceptionListener> exceptionHandlers = new HashMap();

    @Override
    public void addExceptionListener(ExceptionListener exListener) {
        if (exListener == null) {
            return;
        }
        this.exceptionHandlers.put(exListener, exListener);
    }

    @Override
    public void removeExceptionListener(ExceptionListener exListener) {
        if (exListener == null) {
            return;
        }
        this.exceptionHandlers.remove(exListener);
    }

    public void sendException(Object source, Exception exception) {
        ExceptionEvent evt = new ExceptionEvent(source, exception);
        Collection<ExceptionListener> handlers = this.exceptionHandlers.values();
        for (ExceptionListener listener : handlers) {
            listener.exceptionThrown(evt);
        }
    }
}

