/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MathExt {
    private MathExt() {
    }

    public static final int getMaximumOf(int ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return Integer.MIN_VALUE;
        }
        int maximum = Integer.MIN_VALUE;
        int i = 0;
        while (i < numbers.length) {
            if (numbers[i] > maximum) {
                maximum = numbers[i];
            }
            ++i;
        }
        return maximum;
    }

    public static final int getMinimumOf(int ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return Integer.MAX_VALUE;
        }
        int minimum = Integer.MAX_VALUE;
        int i = 0;
        while (i < numbers.length) {
            if (numbers[i] < minimum) {
                minimum = numbers[i];
            }
            ++i;
        }
        return minimum;
    }

    public static final double getMaximumOf(double ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return Double.MIN_VALUE;
        }
        double maximum = Double.MIN_VALUE;
        int i = 0;
        while (i < numbers.length) {
            if (numbers[i] > maximum) {
                maximum = numbers[i];
            }
            ++i;
        }
        return maximum;
    }

    public static final double getMinimumOf(double ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return Double.MAX_VALUE;
        }
        double minimum = Double.MAX_VALUE;
        int i = 0;
        while (i < numbers.length) {
            if (numbers[i] < minimum) {
                minimum = numbers[i];
            }
            ++i;
        }
        return minimum;
    }

    public static double getSum(double[] numbers) {
        double sum = 0.0;
        double[] dArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            double n3 = dArray[n2];
            sum += n3;
            ++n2;
        }
        return sum;
    }

    public static double getMean(double[] numbers) {
        double sum = MathExt.getSum(numbers);
        return sum / (double)numbers.length;
    }

    public static double getVariance(double[] numbers) {
        double mean = MathExt.getMean(numbers);
        double variance = 0.0;
        double[] dArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            double n3 = dArray[n2];
            double meanDelta = n3 - mean;
            double deltaSquare = meanDelta * meanDelta;
            variance += deltaSquare;
            ++n2;
        }
        return variance /= (double)numbers.length;
    }

    public static double getStandardDeviation(double[] numbers) {
        double variance = MathExt.getVariance(numbers);
        return Math.sqrt(variance);
    }

    public static Point2D getCenter(Dimension2D dimension) {
        double centerX = dimension.getWidth() / 2.0;
        double centerY = dimension.getHeight() / 2.0;
        return new Point2D.Double(centerX, centerY);
    }

    public static double getAngleFromOrigin(Point origin, Point destination) {
        double deltaX = destination.getX() - origin.getX();
        double deltaY = destination.getY() - origin.getY();
        double degrees = Math.toDegrees(Math.atan2(deltaY, deltaX));
        double absoluteDegrees = degrees < 0.0 ? 360.0 + degrees : degrees;
        double trueDegrees = absoluteDegrees + 90.0;
        if (trueDegrees >= 360.0) {
            trueDegrees -= 360.0;
        }
        return trueDegrees;
    }

    public static Point2D getPointFromOrigin(Point2D origin, double angle, double distance) {
        double radians = Math.toRadians(angle);
        double x = Math.cos(radians) * distance + origin.getX();
        double y = Math.sin(radians) * distance + origin.getY();
        return new Point2D.Double(x, y);
    }

    public static long[] getFactors(long number) {
        ArrayList<Long> divisors = new ArrayList<Long>();
        divisors.add(1L);
        divisors.add(number);
        int sqrt = (int)Math.sqrt(number) + 1;
        long i = 2L;
        while (i < (long)sqrt) {
            if (number % i == 0L) {
                long d = number / i;
                divisors.add(i);
                divisors.add(d);
            }
            ++i;
        }
        Collections.sort(divisors);
        return MathExt.toLongArray(divisors);
    }

    public static long getLeastCommonMultiple(long[] numbers) {
        long max;
        Arrays.sort(numbers);
        long lcm = max = numbers[numbers.length - 1];
        long n = 1L;
        while (true) {
            int i = 0;
            while (i < numbers.length) {
                if (lcm % numbers[i] != 0L) break;
                ++i;
            }
            if (i == numbers.length) break;
            lcm = max * ++n;
        }
        return lcm;
    }

    public static long getGreatestCommonFactor(long n1, long n2) {
        if (n2 > n1) {
            long t = n1;
            n1 = n2;
            n2 = t;
        }
        while (n2 != 0L) {
            long m = n1 % n2;
            n1 = n2;
            n2 = m;
        }
        return n1;
    }

    /*
     * Unable to fully structure code
     */
    public static long[] getPrimeFactors(long number) {
        factors = new ArrayList<Long>();
        if (number >= 0L && number <= 3L) {
            factors.add(number);
            return MathExt.toLongArray(factors);
        }
        if (number >= -3L && number <= -1L) {
            factors.add(-1L);
            factors.add(number);
            return MathExt.toLongArray(factors);
        }
        v0 = n = number < 0L ? number * -1L : number;
        if (number < 0L) {
            factors.add(-1L);
        }
        i = 2L;
        ** GOTO lbl24
        {
            factors.add(i);
            n /= i;
            do {
                if (n % i == 0L) continue block0;
                ++i;
lbl24:
                // 2 sources

            } while (i <= n / i);
        }
        if (n > 1L) {
            factors.add(n);
        }
        if (factors.size() == 0) {
            factors.add(number);
        }
        return MathExt.toLongArray(factors);
    }

    private static long[] toLongArray(List<Long> list) {
        long[] array = new long[list.size()];
        int i = 0;
        while (i < list.size()) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }
}

