/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.math;

import com.jmorgan.util.Date;
import com.jmorgan.util.DateMetaData;

public final class DateMath {
    public static final int FIRST = 1;
    public static final int SECOND = 2;
    public static final int THIRD = 3;
    public static final int FOURTH = 4;
    public static final int FIFTH = 5;
    public static final int LAST = 10000;

    private DateMath() {
    }

    public static Date getWeekdayOcurrence(int occurrence, int weekday, int month, int year) throws IllegalArgumentException {
        if (occurrence < 1 || occurrence > 10000 || occurrence > 5 && occurrence < 10000) {
            throw new IllegalArgumentException("The value of the occurrence (" + occurrence + ") is invalid.");
        }
        if (weekday < 1 || weekday > 7) {
            throw new IllegalArgumentException("The value of weekday (" + weekday + ") is invalid.");
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("The value of month (" + month + ") is invalid.");
        }
        Date date = null;
        if (occurrence == 10000) {
            date = new Date(month, DateMetaData.getDaysInMonth(month, year), year);
            while (date.getWeekDay() != weekday) {
                date.addDays(-1);
            }
        } else {
            date = DateMath.getWeekDayDate(month, year, weekday, occurrence);
            if (date.getMonth() != month) {
                throw new IllegalArgumentException("The FIFTH occurrence of the given weekday does not exist.");
            }
        }
        return date;
    }

    public static Date getWeekdayOcurrence(int occurrence, int weekday, int year) throws IllegalArgumentException {
        if (occurrence < 1 || occurrence > 53) {
            throw new IllegalArgumentException("The value of the occurrence (" + occurrence + ") is not possible.");
        }
        if (weekday < 1 || weekday > 7) {
            throw new IllegalArgumentException("The value of weekday (" + weekday + ") is invalid.");
        }
        Date date = null;
        if (occurrence == 10000) {
            date = new Date(12, 31, year);
            while (date.getWeekDay() != weekday) {
                date.addDays(-1);
            }
        } else {
            date = DateMath.getWeekDayDate(1, year, weekday, occurrence);
        }
        return date;
    }

    private static Date getWeekDayDate(int month, int year, int weekday, int occurrence) {
        Date date = new Date(month, 1, year);
        while (date.getWeekDay() != weekday) {
            date.addDays(1);
        }
        date.addDays(7 * (occurrence - 1));
        return date;
    }

    public static long getDayDifference(java.util.Date thisDate, java.util.Date thatDate) {
        return DateMath.getDayDifference(new Date(thisDate), new Date(thatDate));
    }

    public static long getDayDifference(Date thisDate, Date thatDate) {
        if (thisDate == null) {
            throw new NullPointerException("The 'thisDate' parameter in DateMath.getDayDifference(Date thisDate, Date thatDate) cannot be NULL.");
        }
        if (thatDate == null) {
            throw new NullPointerException("The 'thatDate' parameter in DateMath.getDayDifference(Date thisDate, Date thatDate) cannot be NULL.");
        }
        if (thisDate.equals(thatDate)) {
            return 0L;
        }
        long thisDateTime = thisDate.getCalendar().getTimeInMillis();
        long thatDateTime = thatDate.getCalendar().getTimeInMillis();
        return (thatDateTime - thisDateTime) / 86400000L;
    }

    public static long getWeekDifference(Date thisDate, Date thatDate) {
        if (thisDate.equals(thatDate)) {
            return 0L;
        }
        long days = DateMath.getDayDifference(thisDate, thatDate);
        return days / 7L;
    }

    public static long getMonthDifference(Date thisDate, Date thatDate) {
        return DateMath.getDifference(thisDate, thatDate, 2);
    }

    public static long getYearDifference(Date thisDate, Date thatDate) {
        return DateMath.getDifference(thisDate, thatDate, 1);
    }

    private static long getDifference(Date thisDate, Date thatDate, int field) {
        Date date2;
        Date date1;
        if (thisDate.equals(thatDate)) {
            return 0L;
        }
        if (field != 2 && field != 1) {
            throw new IllegalArgumentException("The field (" + field + ") is not valid.");
        }
        int multiplier = 1;
        if (thisDate.equals(thatDate)) {
            return 0L;
        }
        if (thisDate.isBefore(thatDate)) {
            date1 = (Date)thisDate.clone();
            date2 = thatDate;
            multiplier = 1;
        } else {
            date1 = (Date)thatDate.clone();
            date2 = thisDate;
            multiplier = -1;
        }
        int diff = -1;
        while (date1.isBefore(date2)) {
            if (field == 2) {
                date1.addMonths(1);
            }
            if (field == 1) {
                date1.addYears(1);
            }
            ++diff;
        }
        return diff * multiplier;
    }
}

