/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.net;

import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Date;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class DefaultHostNameVerifier
implements HostnameVerifier {
    @Override
    public boolean verify(String hostIP, SSLSession sslSession) {
        System.out.printf("DefaultHostNameVerifier.verify(hostIP = %s, SSLSession sslSession)\r\n", hostIP);
        String cipherSuite = sslSession.getCipherSuite();
        long creationTime = sslSession.getCreationTime();
        long lastAccessedTime = sslSession.getLastAccessedTime();
        Certificate[] localCertificates = sslSession.getLocalCertificates();
        DefaultHostNameVerifier.listCertificates("Local Certificates", localCertificates);
        Principal localPrincipal = sslSession.getLocalPrincipal();
        String localPrincipalName = localPrincipal == null ? "No Principal Sent" : localPrincipal.getName();
        try {
            Principal peerPrincipal = sslSession.getPeerPrincipal();
            String peerPrincipalName = peerPrincipal.getName();
            Certificate[] peerCertificates = sslSession.getPeerCertificates();
            if (peerCertificates != null) {
                DefaultHostNameVerifier.listCertificates(peerPrincipalName + " Peer Certificates", peerCertificates);
            }
        }
        catch (SSLPeerUnverifiedException e) {
            e.printStackTrace();
        }
        System.out.printf("\t%20s %20s %20s %20s\r\n", "Cipher Suite", "Creation Time", "Last Access Time", "Local Principal Name");
        System.out.printf("\t%20s %20s %20s %20s\r\n", cipherSuite, new Date(creationTime).toString(), new Date(lastAccessedTime).toString(), localPrincipalName);
        return true;
    }

    private static void listCertificates(String title, Certificate[] certificates) {
        if (certificates == null) {
            return;
        }
        System.out.printf("\t%25s\r\n", title);
        System.out.printf("\t%25s\r\n", "Type\r\n");
        Certificate[] certificateArray = certificates;
        int n = certificates.length;
        int n2 = 0;
        while (n2 < n) {
            Certificate certificate = certificateArray[n2];
            if (certificate != null) {
                System.out.printf("\t%25s\r\n", certificate.getType());
            }
            ++n2;
        }
    }
}

