/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.net;

import com.jmorgan.io.Base64EncoderDecoder;
import com.jmorgan.io.XMLReader;
import com.jmorgan.net.DefaultHostNameVerifier;
import com.jmorgan.net.DefaultTrustManager;
import com.jmorgan.net.URLContent;
import com.jmorgan.net.URLReader;
import com.jmorgan.net.URLZipContent;
import com.jmorgan.util.Pair;
import java.beans.PersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class HTTPProxy {
    public static final int NO_ENCODING = 0;
    public static final int XML_ENCODING = 1;
    public static final int BASE64_ENCODING = 2;
    private static boolean debugMode = false;
    private HashMap<String, String> requestHeaders = new HashMap();
    private Map<String, List<String>> responseHeaders;
    private String responseCharset;
    private ArrayList<Pair<Class<?>, PersistenceDelegate>> persistenceDelegates = new ArrayList();
    private int connectionTimeout;
    private int readTimeout;

    public static void setDebugMode(boolean state) {
        debugMode = state;
    }

    public void addRequestHeader(String headerName, String headerValue) {
        this.requestHeaders.put(headerName, headerValue);
    }

    public void removeRequestHeader(String headerName) {
        this.requestHeaders.remove(headerName);
    }

    public void clearRequestHeaders() {
        this.requestHeaders.clear();
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseCharset() {
        return this.responseCharset;
    }

    public void addPersistenceDelegate(Class<?> type, PersistenceDelegate persistenceDelegate) {
        if (persistenceDelegate == null || type == null) {
            return;
        }
        this.persistenceDelegates.add(new Pair(type, persistenceDelegate));
    }

    public void removePersistenceDelegate(Class<?> type, PersistenceDelegate persistenceDelegate) {
        if (persistenceDelegate == null) {
            return;
        }
        Pair<Class<?>, PersistenceDelegate> elementToRemove = null;
        for (Pair<Class<?>, PersistenceDelegate> delegate : this.persistenceDelegates) {
            if (!delegate.getFirst().equals(type)) continue;
            elementToRemove = delegate;
            break;
        }
        if (elementToRemove != null) {
            this.persistenceDelegates.remove(elementToRemove);
        }
    }

    public void clearPersistenceDelegates() {
        this.persistenceDelegates.clear();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Object getRequest(URL url) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        return this.readData(url, null);
    }

    public Object getRequest(URL url, HashMap<String, Object> dataToSend) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        Object data = null;
        URLConnection connection = HTTPProxy.openConnection(url);
        this.writeData(url, connection, dataToSend, 1);
        data = this.readData(url, connection);
        return data;
    }

    public int putRequest(URL url, HashMap<String, Object> dataToPut) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        return this.putRequest(url, dataToPut, 1);
    }

    public int putRequest(URL url, HashMap<String, Object> dataToPut, int encodingType) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        return this.writeData(url, HTTPProxy.openConnection(url), dataToPut, encodingType);
    }

    private static URLConnection openConnection(URL url) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        URLConnection connection;
        if (url.getProtocol().equals("https")) {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            SSLContext.setDefault(ctx);
        }
        if ((connection = url.openConnection()) instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setHostnameVerifier(new DefaultHostNameVerifier());
        }
        connection.setUseCaches(false);
        return connection;
    }

    private Object readData(URL url, URLConnection connection) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        String data = null;
        if (connection == null) {
            connection = HTTPProxy.openConnection(url);
        }
        this.addRequestHeaders(connection);
        connection.setConnectTimeout(this.connectionTimeout);
        connection.setReadTimeout(this.readTimeout);
        URLReader urlReader = new URLReader(url, connection);
        URLContent<String> urlContent = urlReader.getData();
        this.responseCharset = urlReader.getConnectionInfo().getContentCharset();
        this.responseHeaders = connection.getHeaderFields();
        if (urlContent instanceof URLZipContent) {
            String content = urlContent.getContent();
            if (content.contains("<java version=") && content.contains("class=\"java.beans.XMLDecoder\">")) {
                XMLReader reader = new XMLReader();
                try {
                    data = reader.decodeXMLData(content);
                }
                catch (Exception e) {
                    data = content;
                }
            } else {
                data = content;
            }
        } else {
            data = urlContent.getContent();
        }
        if (debugMode) {
            System.out.println("HTTPProxy.readData(...): " + url.toString());
            HTTPProxy.dumpConnectionHeaders(urlReader.getConnectionInfo().getHeaders());
        }
        return data;
    }

    private int writeData(URL url, URLConnection connection, HashMap<String, Object> dataToSend, int encodingType) throws IOException {
        if (dataToSend == null || dataToSend.size() == 0) {
            return 204;
        }
        try {
            if (connection == null) {
                connection = HTTPProxy.openConnection(url);
            }
            this.addRequestHeaders(connection);
            connection.setDoOutput(true);
            OutputStream out = connection.getOutputStream();
            PrintStream ps = new PrintStream(out, true, "ISO-8859-1");
            XMLEncoder xmlEncoder = null;
            if (encodingType == 1) {
                xmlEncoder = new XMLEncoder(ps);
                for (Pair<Class<?>, PersistenceDelegate> pd : this.persistenceDelegates) {
                    xmlEncoder.setPersistenceDelegate((Class)pd.first, (PersistenceDelegate)pd.second);
                }
            }
            int keyNum = 0;
            for (String key : dataToSend.keySet()) {
                Object value = dataToSend.get(key);
                if (keyNum > 0) {
                    ps.print("&");
                }
                ps.print(key + "=");
                if (encodingType == 1) {
                    xmlEncoder.writeObject(value);
                } else if (encodingType == 2) {
                    String encodedBean = Base64EncoderDecoder.encodeObject((Serializable)value);
                    ps.print(encodedBean);
                } else {
                    ps.print(value);
                }
                ++keyNum;
            }
            if (encodingType == 1) {
                xmlEncoder.flush();
                xmlEncoder.close();
            }
            ps.flush();
            out.flush();
            Map<String, List<String>> headers = connection.getHeaderFields();
            if (debugMode) {
                System.out.println("HTTPProxy.writeData(...): " + url.toString());
                HTTPProxy.dumpConnectionHeaders(headers);
            }
            return 200;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            System.err.println("HTTPProxy.writeData(url=" + String.valueOf(url) + ", connection, dataToSend, encodingType=1):  Unknown Exception:\n" + String.valueOf(e));
            return 0;
        }
    }

    private void addRequestHeaders(URLConnection connection) {
        for (String headerName : this.requestHeaders.keySet()) {
            String headerValue = this.requestHeaders.get(headerName);
            connection.addRequestProperty(headerName, headerValue);
        }
    }

    private static void dumpConnectionHeaders(Map<String, List<String>> headers) {
        for (String headerKey : headers.keySet()) {
            List<String> headerValues = headers.get(headerKey);
            System.out.println("\tHeader: " + headerKey);
            for (String value : headerValues) {
                System.out.println("\t\tValue: " + value);
            }
        }
    }
}

