/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;

public abstract class URLContent<T> {
    private static final int BUFSIZE = 32768;
    private String contentType;
    private String contentEncoding;
    private String contentCharset;
    private long contentLength;
    private byte[] rawData;

    public URLContent(URLConnection connection) {
        try {
            this.contentType = URLConnection.guessContentTypeFromStream(connection.getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.contentType == null) {
            this.contentType = connection.getContentType();
        }
        this.contentEncoding = connection.getContentEncoding();
        this.contentLength = connection.getContentLengthLong();
        int charSetPos = this.contentType.indexOf("charset=");
        this.contentCharset = charSetPos == -1 ? "ISO-8859-1" : this.contentType.substring(charSetPos + 8).toUpperCase();
        if (this.contentLength <= 0L) {
            this.contentLength = 32768L;
        } else if (this.contentLength > 32768L) {
            this.contentLength = 32768L;
        }
        int bufferSize = (int)this.contentLength;
        try {
            InputStream inputStream = connection.getInputStream();
            BufferedInputStream bin = new BufferedInputStream(inputStream, bufferSize);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(bufferSize);
            byte[] buff = new byte[bufferSize];
            int bytesRead = 0;
            while ((bytesRead = bin.read(buff)) != -1) {
                bout.write(buff, 0, bytesRead);
            }
            inputStream.close();
            this.rawData = bout.toByteArray();
        }
        catch (Exception e) {
            this.rawData = new byte[0];
            e.printStackTrace();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getContentLength() {
        return this.rawData.length;
    }

    public String getContentCharset() {
        return this.contentCharset;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public abstract T getContent();

    protected InputStream getDataStream() {
        return new ByteArrayInputStream(this.rawData);
    }
}

