/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.print;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.print.AbstractColumnPrinter;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.Collection;

public class BeanPrinter<T>
extends AbstractColumnPrinter {
    private Collection<T> beans;
    private String[] printableProperties;

    public BeanPrinter() {
    }

    public BeanPrinter(Collection<T> beans) {
        this();
        this.setBeans(beans);
    }

    public Collection<T> getBeans() {
        return this.beans;
    }

    public void setBeans(Collection<T> beans) {
        this.beans = beans;
    }

    public String[] getPrintableProperties() {
        if (this.printableProperties == null) {
            this.printableProperties = BeanService.getPropertyNames(this.getBeanPrototype()).toArray(new String[0]);
        }
        return this.printableProperties;
    }

    public void setPrintableProperties(String[] printableProperties) {
        this.printableProperties = printableProperties;
    }

    private T getBeanPrototype() {
        return this.beans.iterator().next();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        super.print(graphics, pageFormat, pageIndex);
        double y = pageFormat.getImageableY();
        double width = pageFormat.getImageableWidth();
        double height = pageFormat.getImageableHeight();
        int rowCount = this.beans.size();
        if (rowCount == 0) {
            return 1;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int fontHeight = fontMetrics.getHeight();
        y += (double)fontHeight;
        int columnCount = this.columnHeaders.length;
        int columnIndex = 0;
        while (columnIndex < columnCount) {
            graphics.drawString(this.columnHeaders[columnIndex], this.columnX[columnIndex], (int)y);
            int columnWidth = fontMetrics.stringWidth(this.columnHeaders[columnIndex]);
            graphics.drawLine(this.columnX[columnIndex], (int)(y + 2.0), this.columnX[columnIndex] + columnWidth, (int)(y + 2.0));
            if ((double)this.columnX[columnIndex + 1] > width) break;
            ++columnIndex;
        }
        int imageableRowCount = (int)Math.floor((height -= (double)fontHeight) / (double)fontHeight);
        int startingRow = imageableRowCount * pageIndex;
        if (startingRow > rowCount) {
            return 1;
        }
        int endingRow = startingRow + imageableRowCount;
        if (endingRow > rowCount) {
            endingRow = rowCount;
        }
        block1: for (T bean : this.beans) {
            y += (double)fontHeight;
            int column = 0;
            while (column < this.printableProperties.length) {
                Object value = BeanService.getPropertyValue(bean, this.printableProperties[column]);
                if (value != null) {
                    String sValue = value.toString();
                    graphics.drawString(sValue, this.columnX[column], (int)y);
                    if ((double)this.columnX[column + 1] > width) continue block1;
                }
                ++column;
            }
        }
        return 0;
    }

    @Override
    protected String[] getColumnHeaders() {
        if (this.columnHeaders != null) {
            return this.columnHeaders;
        }
        return BeanService.getPropertyNames(this.getBeanPrototype()).toArray(new String[0]);
    }

    @Override
    protected int[] getColumnX(FontMetrics fontMetrics, PageFormat pageFormat) {
        int columnCount = this.getColumnHeaders().length;
        int[] columnX = new int[columnCount + 1];
        int row = 0;
        if (this.printableProperties == null) {
            this.printableProperties = this.getPrintableProperties();
        }
        for (T bean : this.beans) {
            double x = pageFormat.getImageableX();
            int column = 0;
            while (column < this.printableProperties.length) {
                if ((double)columnX[column] < x) {
                    columnX[column] = (int)x;
                }
                int dataWidth = 0;
                if (row == 0) {
                    dataWidth = fontMetrics.stringWidth(this.columnHeaders[column]);
                }
                ++row;
                Object value = BeanService.getPropertyValue(bean, this.printableProperties[column]);
                if (value != null) {
                    String sValue = value.toString();
                    dataWidth = Math.max(dataWidth, fontMetrics.stringWidth(sValue));
                    x += (double)(dataWidth + this.columnSpacing);
                }
                ++column;
            }
        }
        columnX[columnCount] = Integer.MAX_VALUE;
        return columnX;
    }
}

