/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.print;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class ComponentPrinter {
    private ComponentPrinter() {
    }

    public static void printComponent(String printJobName, final Component component) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName(printJobName);
        pj.setPrintable(new Printable(){

            @Override
            public int print(Graphics graphics, PageFormat pageFormat, int pageNumber) {
                if (pageNumber > 0) {
                    return 1;
                }
                Graphics2D g2 = (Graphics2D)graphics;
                g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                double pageWidth = pageFormat.getImageableWidth();
                double pageHeight = pageFormat.getImageableHeight();
                int panelWidth = component.getWidth();
                int panelHeight = component.getHeight();
                double scale = 1.0;
                if ((double)panelWidth > pageWidth) {
                    scale = pageWidth / (double)panelWidth;
                }
                if ((double)panelHeight > pageHeight) {
                    scale = pageHeight / (double)panelHeight;
                }
                g2.scale(scale, scale);
                component.paint(g2);
                return 0;
            }
        });
        if (!pj.printDialog()) {
            return;
        }
        try {
            pj.print();
        }
        catch (PrinterException ex) {
            System.out.println(ex);
        }
    }
}

