/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.rules;

import com.jmorgan.rules.Rule;
import java.util.Collection;

public class CollectionContainsRule<T>
implements Rule {
    public static final int IS_IN = 0;
    public static final int IS_NOT_IN = 1;
    private Collection<T> collection;
    private T object;
    private int comparisonType;

    public CollectionContainsRule(Collection<T> collection, T object) {
        this.setCollection(collection);
        this.setObject(object);
        this.setComparisonType(0);
    }

    public CollectionContainsRule(Collection<T> collection, T object, int comparisonType) {
        this(collection, object);
        this.setComparisonType(comparisonType);
    }

    public Collection<T> getCollection() {
        return this.collection;
    }

    public void setCollection(Collection<T> collection) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException("The parameter to " + this.getClass().getName() + ".setCollection(Collection<T> collection) is not allowed to be null.");
        }
        this.collection = collection;
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("The parameter to " + this.getClass().getName() + ".setObject(T object) is not allowed to be null.");
        }
        this.object = object;
    }

    public int getComparisonType() {
        return this.comparisonType;
    }

    public void setComparisonType(int comparisonType) throws IllegalArgumentException {
        switch (comparisonType) {
            case 0: 
            case 1: {
                this.comparisonType = comparisonType;
                break;
            }
            default: {
                throw new IllegalArgumentException("The parameter to " + this.getClass().getName() + ".setComparisonType(int comparisonType) is not valid.");
            }
        }
    }

    @Override
    public boolean isTrue() {
        boolean found = this.collection.contains(this.object);
        if (found && this.comparisonType == 0) {
            return true;
        }
        return !found && this.comparisonType == 1;
    }
}

