/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.event.MouseEventInvoker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.UIManager;

public class ActiveLabel
extends JMLabel {
    private ArrayList<ActionListener> actionListeners;
    private String actionCommand;
    private boolean drawUnderline;

    static {
        if (UIManager.getColor("ActiveLabel.foreground") == null) {
            UIManager.put("ActiveLabel.foreground", Color.BLUE);
        }
        if (UIManager.getColor("ActiveLabel.disabledForeground") == null) {
            UIManager.put("ActiveLabel.disabledForeground", Color.GRAY);
        }
    }

    public ActiveLabel() {
        this.standardInit(null);
    }

    public ActiveLabel(Icon image) {
        super(image);
        this.standardInit(null);
    }

    public ActiveLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.standardInit(null);
    }

    public ActiveLabel(String text) {
        super(text);
        this.standardInit(text);
    }

    public ActiveLabel(String text, Icon image, int horizontalAlignment) {
        super(text, image, horizontalAlignment);
        this.standardInit(text);
    }

    public ActiveLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.standardInit(text);
    }

    public ActiveLabel(String text, Component c) {
        super(text, c);
        this.standardInit(text);
    }

    public boolean getDrawUnderline() {
        return this.drawUnderline;
    }

    public void setDrawUnderline(boolean drawUnderline) {
        this.drawUnderline = drawUnderline;
    }

    public void setActionCommand(String actionCommand) {
        if (actionCommand != null) {
            this.actionCommand = actionCommand;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListeners.remove(actionListener);
    }

    public void sendActionEvent() {
        if (this.actionListeners.size() == 0) {
            return;
        }
        ActionEvent event = new ActionEvent(this, 1, this.actionCommand);
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(event);
        }
    }

    private void standardInit(String actionCommand) {
        this.actionListeners = new ArrayList();
        new MouseEventInvoker((Object)this, 1, this, "sendActionEvent");
        this.setActionCommand(actionCommand);
        this.setCursor(new Cursor(12));
        this.setForeground(UIManager.getColor("ActiveLabel.foreground"));
        this.setFocusable(true);
        this.drawUnderline = true;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.drawUnderline) {
            g.setColor(this.isEnabled() ? this.getForeground() : UIManager.getColor("ActiveLabel.disabledForeground"));
            int w = this.getWidth();
            int y = this.getHeight() - 1;
            g.drawLine(0, y, w, y);
        }
    }
}

