/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.swing.JMFormattedTextField;
import com.jmorgan.util.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class DateField
extends JMFormattedTextField {
    private String formatString;
    public static final String TWODIGITFORMAT = "MM/dd/yyyy";
    public static final String SHORTDATEFORMAT = "MMM dd, yyyy";
    public static final String LONGDATEFORMAT = "MMMM dd, yyyy";

    public DateField() {
        this(new GregorianCalendar(), 10);
    }

    public DateField(Calendar date) {
        this(date, 10);
    }

    public DateField(int columns) {
        this(new GregorianCalendar(), columns);
    }

    public DateField(Calendar date, int columns) {
        this.setColumns(columns);
        this.setFormatString(TWODIGITFORMAT);
        this.setDate(date);
    }

    public Calendar getDate() {
        if (this.isNull()) {
            return null;
        }
        Date d = new Date((java.util.Date)this.getValue());
        return d.getCalendar();
    }

    public void setDate(Calendar newDate) {
        if (newDate == null) {
            this.setNull(true);
        } else {
            this.setValue(newDate.getTime());
        }
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String newFormatString) {
        if (this.propertyChangeSupport != null) {
            this.firePropertyChange("formatString", this.formatString, newFormatString);
        }
        this.formatString = newFormatString;
        DateFormatter df = new DateFormatter(new SimpleDateFormat(newFormatString));
        df.setCommitsOnValidEdit(true);
        this.setFormatterFactory(new DefaultFormatterFactory(df, df, df, df));
    }
}

