/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.beans.JMBean;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

public class HotSpot
extends JMBean
implements MouseMotionListener,
MouseListener {
    private Component component;
    private Shape hotspot;
    private Cursor cursor;
    private Cursor oldCursor;
    private ArrayList<ActionListener> actionListeners;
    private boolean hotspotActive;
    private String actionCommand;
    private String name;

    public HotSpot() {
    }

    public HotSpot(Shape hotspot, Component component) {
        this(hotspot, component, new Cursor(12));
    }

    public HotSpot(Shape hotspot, Component component, Cursor cursor) {
        this(hotspot, component, cursor, "hotspot");
    }

    public HotSpot(Shape hotspot, Component component, String actionCommand) {
        this(hotspot, component, new Cursor(12), actionCommand);
    }

    public HotSpot(Shape hotspot, Component component, Cursor cursor, String actionCommand) {
        this.setHotspot(hotspot);
        this.setComponent(component);
        this.setCursor(cursor);
        this.setActionCommand(actionCommand);
        this.hotspotActive = false;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        if (this.component != null) {
            this.component.removeMouseListener(this);
            this.component.removeMouseMotionListener(this);
        }
        this.component = component;
        if (component == null) {
            return;
        }
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
    }

    public Shape getHotspot() {
        return this.hotspot;
    }

    public void setHotspot(Shape hotspot) {
        this.hotspot = hotspot;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.actionCommand == null && this.name != null) {
            this.setActionCommand(this.name);
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
        if (this.name == null && this.actionCommand != null) {
            this.setName(this.actionCommand);
        }
    }

    public void addActionListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList();
        }
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (listener == null || this.actionListeners == null) {
            return;
        }
        this.actionListeners.remove(listener);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public synchronized void mouseMoved(MouseEvent e) {
        Point mouseLocation = e.getPoint();
        if (this.hotspot.contains(mouseLocation)) {
            if (!this.hotspotActive) {
                this.oldCursor = this.component.getCursor();
                this.component.setCursor(this.cursor);
                this.hotspotActive = true;
            }
        } else if (this.hotspotActive) {
            this.component.setCursor(this.oldCursor);
            this.hotspotActive = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.actionListeners == null) {
            return;
        }
        Point mouseLocation = e.getPoint();
        if (this.hotspot.contains(mouseLocation)) {
            ActionEvent event = new ActionEvent(this, 1001, this.actionCommand);
            for (ActionListener listener : this.actionListeners) {
                listener.actionPerformed(event);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

