/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.StringUtility;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;

public class JMCheckBox
extends JCheckBox
implements PropertyChangeNotifier,
Customizer {
    protected PropertyChangeSupport propertyChangeSupport;
    private String imageName;
    private boolean isNull;

    public JMCheckBox() {
        this.standardInit();
    }

    public JMCheckBox(Icon icon) {
        super(icon);
        this.standardInit();
    }

    public JMCheckBox(Icon icon, boolean selected) {
        super(icon, selected);
        this.standardInit();
    }

    public JMCheckBox(String text) {
        super(text);
        this.standardInit();
    }

    public JMCheckBox(String text, boolean selected) {
        super(text, selected);
        this.standardInit();
    }

    public JMCheckBox(String text, Icon icon) {
        super(text, icon);
        this.standardInit();
    }

    public JMCheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.standardInit();
    }

    public boolean isNull() {
        return this.isNull;
    }

    public void setNull(boolean isNull) {
        this.isNull = isNull;
        this.setSelected(false);
    }

    void standardInit() {
        LabelUtility.parseLabel(this);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        new ItemEventInvoker(this, this, "selectionChanged");
    }

    public void selectionChanged() {
        this.handlePropertyChange(!this.isSelected(), this.isSelected());
    }

    @Override
    public void setObject(Object value) {
        this.setSelected((Boolean)value);
    }

    @Override
    public void setSelected(boolean b) {
        boolean oldValue = this.isSelected();
        super.setSelected(b);
        new AsynchMethodInvoker((Object)this, "handlePropertyChange", new Object[]{oldValue, b});
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void handlePropertyChange(boolean oldValue, boolean newValue) {
        if (this.propertyChangeSupport != null && oldValue != newValue) {
            String fieldName = this.getName();
            this.propertyChangeSupport.firePropertyChange(StringUtility.isEmpty(fieldName) ? "selected" : fieldName, oldValue, newValue);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }
}

