/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.awt.ShapeCreator;
import com.jmorgan.awt.ShapePainter;
import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.swing.util.FocusSelector;
import com.jmorgan.util.StringUtility;
import java.awt.AWTKeyStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;

public class JMFormattedTextField
extends JFormattedTextField
implements PropertyChangeNotifier,
Customizer {
    private ShapeCreator shapeCreator;
    private ShapePainter shapePainterDelegate;
    private boolean isNull;
    private String nullRenderValue;
    protected PropertyChangeSupport propertyChangeSupport;

    public JMFormattedTextField() {
        new FocusSelector(this);
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>();
        keys.add(AWTKeyStroke.getAWTKeyStroke(10, 0));
        keys.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        this.setFocusTraversalKeys(0, keys);
        ShapeCreator shapeCreator = (ShapeCreator)UIManager.get("TextField.shapeCreator");
        if (shapeCreator != null) {
            this.setShapeCreator(shapeCreator);
        }
    }

    public JMFormattedTextField(Object value) {
        this();
        this.setValue(value);
    }

    @Override
    public void setValue(Object value) {
        Object oldValue = this.getValue();
        if (value == null) {
            super.setValue(this.nullRenderValue);
        } else {
            super.setValue(value);
        }
        if (this.propertyChangeSupport != null) {
            String fieldName = this.getName();
            this.propertyChangeSupport.firePropertyChange(StringUtility.isEmpty(fieldName) ? "value" : fieldName, oldValue, value);
        }
    }

    @Override
    public void setObject(Object value) {
        this.setValue(value);
    }

    public boolean isNull() {
        return this.isNull;
    }

    public void setNull(boolean isNull) {
        this.isNull = isNull;
        super.setValue(this.nullRenderValue);
    }

    public String getNullRenderValue() {
        return this.nullRenderValue;
    }

    public void setNullRenderValue(String nullRenderValue) {
        this.nullRenderValue = nullRenderValue;
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    public ShapeCreator getShapeCreator() {
        return this.shapeCreator;
    }

    public void setShapeCreator(ShapeCreator shapeCreator) {
        this.shapePainterDelegate = null;
        this.shapeCreator = shapeCreator;
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.shapeCreator != null) {
            if (this.shapePainterDelegate == null) {
                this.shapePainterDelegate = new ShapePainter(this, this.shapeCreator.createShape(this.getBounds()));
            }
            this.shapePainterDelegate.paintBorder(g);
        } else {
            super.paintBorder(g);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        if (this.shapeCreator != null) {
            if (this.shapePainterDelegate == null) {
                this.shapePainterDelegate = new ShapePainter(this, this.shapeCreator.createShape(this.getBounds()));
            }
            this.shapePainterDelegate.paintComponent(g);
        }
        super.paintComponent(g);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.propertyChangeSupport == null || listener == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

