/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.awt.ShapePainter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JLayeredPane;

public class JMLayeredPane
extends JLayeredPane {
    private int currentComponentZOrder;
    private int zOrderIncrement;
    private ShapePainter shapePainterDelegate;
    private Paint backgroundPaint;

    public JMLayeredPane() {
        this(0, 10);
    }

    public JMLayeredPane(int initialZOrderValue, int zOrderIncrement) {
        this.setZOrderIncrement(zOrderIncrement);
        this.setCurrentComponentZOrder(initialZOrderValue);
    }

    public Integer getNextComponentZOrder() {
        this.currentComponentZOrder += this.zOrderIncrement;
        return this.currentComponentZOrder;
    }

    public int getCurrentComponentZOrder() {
        return this.currentComponentZOrder;
    }

    public void setNextComponentZOrder(int zOrder) {
        this.currentComponentZOrder = zOrder;
    }

    public void setCurrentComponentZOrder(int currentComponentZOrder) {
        this.currentComponentZOrder = currentComponentZOrder - this.zOrderIncrement;
    }

    public int getZOrderIncrement() {
        return this.zOrderIncrement;
    }

    public void setZOrderIncrement(int orderIncrement) {
        this.zOrderIncrement = orderIncrement;
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.setOpaque(this.backgroundPaint == null);
    }

    public void setShape(Shape shape) {
        this.shapePainterDelegate = new ShapePainter(this, shape);
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.shapePainterDelegate != null) {
            this.shapePainterDelegate.paintBorder(g);
        } else {
            super.paintBorder(g);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Paint oldPaint = null;
        Graphics2D g2d = (Graphics2D)g;
        Dimension size = this.getSize();
        if (this.backgroundPaint != null) {
            oldPaint = g2d.getPaint();
            g2d.setPaint(this.backgroundPaint);
        } else {
            g.setColor(this.getBackground());
        }
        if (this.shapePainterDelegate != null) {
            this.shapePainterDelegate.paintComponent(g);
        } else if (this.backgroundPaint != null) {
            g2d.fillRect(0, 0, size.width, size.height);
        }
        super.paintComponent(g);
        if (this.backgroundPaint != null) {
            g2d.setPaint(oldPaint);
        }
    }
}

