/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.util.WindowCloser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class JMMessageBox
extends JMDialog
implements ActionListener {
    public static final int SYSTEM_CANCELLED = -1;
    public static final int OK_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int YES_OPTION = 4;
    public static final int NO_OPTION = 8;
    public static final int ABORT_OPTION = 16;
    public static final int RETRY_OPTION = 32;
    public static final int IGNORE_OPTION = 64;
    public static final int CUSTOM_OPTION = 128;
    public static final int YES_NO_OPTION = 12;
    private static int selection = -1;

    public JMMessageBox(JFrame frame, String title, String message) {
        this(frame, title, message, 1);
    }

    public JMMessageBox(JFrame frame, String message, int options) {
        this(frame, "Close", message, options);
    }

    public JMMessageBox(JFrame frame, String title, String message, int options) {
        super(frame, title, true, new Object[]{message, options});
    }

    public JMMessageBox(JDialog dialog, String title, String message) {
        this(dialog, title, message, 1);
    }

    public JMMessageBox(JDialog dialog, String message, int options) {
        this(dialog, "Close", message, options);
    }

    public JMMessageBox(JDialog dialog, String title, String message, int options) {
        super(dialog, title, true, new Object[]{message, options});
    }

    @Override
    public void buildGUI(Object ... arguments) {
        String message = (String)arguments[0];
        int options = (Integer)arguments[1];
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        JMButton[] bArray = new JMButton[7];
        JMPanel messagePanel = new JMPanel();
        JMLabel messageLabel = new JMLabel(message, 0);
        messagePanel.add(messageLabel);
        c.add((Component)messagePanel, "Center");
        JMPanel buttonPanel = new JMPanel();
        if ((options & 1) == 1) {
            bArray[0] = new JMButton("&OK");
        }
        if ((options & 4) == 4) {
            bArray[1] = new JMButton("&Yes");
        }
        if ((options & 8) == 8) {
            bArray[2] = new JMButton("&No");
        }
        if ((options & 0x10) == 16) {
            bArray[3] = new JMButton("&Abort");
        }
        if ((options & 0x20) == 32) {
            bArray[4] = new JMButton("&Retry");
        }
        if ((options & 0x40) == 64) {
            bArray[6] = new JMButton("&Ignore");
        }
        if ((options & 2) == 2) {
            bArray[6] = new JMButton("&Cancel");
        }
        int i = 0;
        while (i < bArray.length) {
            if (bArray[i] != null) {
                bArray[i].addActionListener(this);
                buttonPanel.add(bArray[i]);
            }
            ++i;
        }
        c.add((Component)buttonPanel, "South");
    }

    public static int getSelection() {
        return selection;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String button = e.getActionCommand().toLowerCase();
        try {
            if (button.equals("ok")) {
                selection = 1;
                return;
            }
            if (button.equals("cancel")) {
                selection = 2;
                return;
            }
            if (button.equals("yes")) {
                selection = 4;
                return;
            }
            if (button.equals("no")) {
                selection = 8;
                return;
            }
            if (button.equals("abort")) {
                selection = 16;
                return;
            }
            if (button.equals("retry")) {
                selection = 32;
                return;
            }
            if (button.equals("ignore")) {
                selection = 64;
                return;
            }
        }
        finally {
            WindowCloser.closeWindow(this);
        }
    }
}

