/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.swing.util.LabelUtility;
import java.awt.Graphics;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.UIManager;

public class JMRadioButton
extends JRadioButton {
    private static final long serialVersionUID = 2126567660072173351L;
    private String imageName;

    public JMRadioButton() {
        this.standardInit();
    }

    public JMRadioButton(Action a) {
        super(a);
        this.standardInit();
    }

    public JMRadioButton(Icon icon) {
        this(icon, false);
    }

    public JMRadioButton(Icon icon, boolean selected) {
        super(icon, selected);
        this.standardInit();
    }

    public JMRadioButton(String text) {
        this(text, false);
    }

    public JMRadioButton(String text, boolean selected) {
        super(text, selected);
        this.standardInit();
    }

    public JMRadioButton(String text, Icon icon) {
        this(text, icon, false);
    }

    public JMRadioButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.standardInit();
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(UIManager.getColor("RadioButton.background"));
        g.fillRect(3, 3, 15, 15);
        g.setColor(UIManager.getColor("RadioButton.darkShadow"));
        g.drawOval(5, 5, 10, 10);
        if (this.isSelected()) {
            g.fillOval(5, 5, 10, 10);
        }
    }

    private void standardInit() {
        LabelUtility.parseLabel(this);
        this.setOpaque(false);
    }
}

