/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.event.MouseEventInvoker;
import com.jmorgan.swing.slider.JMSliderUI;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Dictionary;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JMSlider
extends JSlider
implements ChangeListener {
    private ArrayList<ChangeListener> changeListeners;
    private int oldValue;
    private Insets insets;
    private boolean fireChangeOnStop;
    private AsynchMethodInvoker<Void> changeAction;

    public JMSlider() {
        this(0);
    }

    public JMSlider(int orientation) {
        super(orientation);
        this.stanardInit();
    }

    public JMSlider(BoundedRangeModel brm) {
        super(brm);
        this.stanardInit();
    }

    public JMSlider(int min, int max) {
        this(0, min, max, 0);
    }

    public JMSlider(int min, int max, int value) {
        this(0, min, max, value);
    }

    public JMSlider(int orientation, int min, int max, int value) {
        super(orientation, min, max, value);
        this.oldValue = value;
        this.stanardInit();
    }

    @Override
    public Insets getInsets() {
        if (this.insets == null) {
            return super.getInsets();
        }
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    public void setLabelTable(Dictionary labels) {
        super.setLabelTable(labels);
        this.setPaintLabels(labels != null);
    }

    public void setLabelTable(int start, int increment) {
        this.setLabelTable(this.createStandardLabels(increment, start));
    }

    public void setTicks(int majorTicks, int minorTicks) {
        this.setMajorTickSpacing(majorTicks);
        this.setMinorTickSpacing(minorTicks);
        this.setPaintTicks(true);
    }

    public void setThumbIcon(Icon icon) {
        ((JMSliderUI)this.getUI()).setThumbIcon(icon);
        this.repaint();
    }

    public int getOldValue() {
        return this.oldValue;
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(listener);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeListeners.toArray(new ChangeListener[0]);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    public boolean getFireChangeOnStop() {
        return this.fireChangeOnStop;
    }

    public void setFireChangeOnStop(boolean state) {
        this.fireChangeOnStop = state;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.fireChangeOnStop) {
            if (this.changeAction != null) {
                this.changeAction.cancel();
            }
            this.changeAction = new AsynchMethodInvoker((Object)this, "fireEvent", 100);
        } else {
            this.fireEvent();
        }
    }

    @Reflected
    private void fireEvent() {
        int value = this.getValue();
        if (value != this.oldValue) {
            this.notifyListeners();
            this.oldValue = value;
        }
    }

    @Reflected
    public void mouseClicked() {
        int min = this.getMinimum();
        int max = this.getMaximum();
        Dimension size = this.getSize();
        int width = size.width - 18;
        Point mousePosition = this.getMousePosition();
        if (mousePosition == null) {
            return;
        }
        int mouseX = mousePosition.x - 9;
        int newValue = (int)((double)min + (double)(max - min) * ((double)mouseX / (double)width));
        this.setValueIsAdjusting(true);
        this.setValue(newValue);
        this.setValueIsAdjusting(false);
    }

    private void notifyListeners() {
        if (this.changeListeners == null) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            if (listener == null) continue;
            listener.stateChanged(changeEvent);
        }
    }

    protected void stanardInit() {
        this.setValue(this.oldValue);
        super.addChangeListener(this);
        new MouseEventInvoker((Object)this, 1, this, "mouseClicked");
    }
}

