/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.beans.PropertyNotFoundException;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.ExceptionDialog;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.ByteArrayTableCellRenderer;
import com.jmorgan.swing.table.CellEditingListener;
import com.jmorgan.swing.table.CellFocusEvent;
import com.jmorgan.swing.table.CellFocusListener;
import com.jmorgan.swing.table.CellHoverListener;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.swing.table.ExcelTableModelExport;
import com.jmorgan.swing.table.RowFocusEvent;
import com.jmorgan.swing.table.RowFocusListener;
import com.jmorgan.swing.table.TableCellEditorRenderer;
import com.jmorgan.swing.table.TimestampTableCellRenderer;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Pair;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JMTable
extends JTable
implements CellEditingListener {
    private static final int EDITING_STARTED = 0;
    private static final int EDITING_STOPPED = 1;
    private boolean printingEnabled;
    private int[] selectedRows;
    private int rowInFocus;
    private int cellInFocus;
    private int rowUnderCursor;
    private int columnUnderCursor;
    private UniqueArrayList<RowFocusListener> rowFocusListeners;
    private UniqueArrayList<CellFocusListener> cellFocusListeners;
    private UniqueArrayList<CellEditingListener> cellEditingListeners;
    private UniqueArrayList<CellHoverListener> cellHoverListeners;
    private TableCellEditorRenderer proxyRenderer;
    private int minimumColumnWidth = 100;
    private int maximumColumnWidth = 600;
    private int nullValueColumnWidth;
    private boolean isEditing;

    public JMTable() {
        this.standardInit();
    }

    public JMTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.standardInit();
    }

    public JMTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.standardInit();
    }

    public JMTable(TableModel dm) {
        super(dm);
        this.standardInit();
    }

    public JMTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.standardInit();
    }

    public JMTable(TableModel dm, TableColumnModel cm, ListSelectionModel lm) {
        super(dm, cm, lm);
        this.standardInit();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        this.rowUnderCursor = row;
        this.columnUnderCursor = column;
        this.notifyCellHoverListeners();
        return c;
    }

    public int getRowUnderCursor() {
        return this.rowUnderCursor;
    }

    public int getColumnUnderCursor() {
        return this.columnUnderCursor;
    }

    public void setRow(int row) {
        Rectangle rect = this.getCellRect(row, 1, true);
        this.scrollRectToVisible(rect);
        this.clearSelection();
        this.selectionModel.setSelectionInterval(row, row);
    }

    public void scrollToRow(int row) {
        if (row < 0 || row > this.getRowCount()) {
            return;
        }
        Rectangle cellRect = this.getCellRect(row, 0, true);
        try {
            this.scrollRectToVisible(cellRect);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSelectedRow(int row) {
        this.setRow(row);
    }

    public void unSelectRow(int row) {
        this.selectionModel.removeSelectionInterval(row, row);
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public int getMinimumColumnWidth() {
        return this.minimumColumnWidth;
    }

    public void setMinimumColumnWidth(int minimumColumnWidth) {
        this.minimumColumnWidth = minimumColumnWidth;
    }

    public int getMaximumColumnWidth() {
        return this.maximumColumnWidth;
    }

    public void setMaximumColumnWidth(int maximumColumnWidth) {
        this.maximumColumnWidth = maximumColumnWidth;
    }

    public int getNullValueColumnWidth() {
        return this.nullValueColumnWidth;
    }

    public void setNullValueColumnWidth(int nullValueColumnWidth) {
        this.nullValueColumnWidth = nullValueColumnWidth;
    }

    public void optimizeColumnWidths() {
        int c;
        int rows = this.getRowCount();
        if (rows == 0) {
            return;
        }
        int cols = this.getColumnCount();
        if (cols == 0) {
            return;
        }
        Pair[] widths = new Pair[cols];
        int i = 0;
        while (i < cols) {
            widths[i] = new Pair<Integer, Integer>(0, 0);
            ++i;
        }
        int r = 0;
        while (r < rows) {
            c = 0;
            while (c < cols) {
                Object value = this.getValueAt(r, c);
                Pair<Integer, Integer> width = this.getOptimalColumnWidth(r, c, value, false, false);
                int cmp = widths[c].compareTo(width);
                if (cmp < 0) {
                    widths[c] = width;
                }
                ++c;
            }
            ++r;
        }
        TableColumnModel tcm = this.getColumnModel();
        c = 0;
        while (c < cols) {
            TableColumn tc = tcm.getColumn(c);
            this.correctColumnWidth(widths[c]);
            tc.setWidth((Integer)widths[c].first);
            tc.setPreferredWidth((Integer)widths[c].second);
            ++c;
        }
    }

    public void optimizeColumnWidths(int sampleRow) {
        int columnCount = this.getColumnCount();
        int c = 0;
        while (c < columnCount) {
            try {
                Object value = this.getValueAt(sampleRow, c);
                Pair<Integer, Integer> width = this.getOptimalColumnWidth(sampleRow, c, value, false, false);
                this.correctColumnWidth(width);
                TableColumn tc = this.getColumnModel().getColumn(this.convertColumnIndexToModel(c));
                tc.setWidth((Integer)width.first);
                tc.setPreferredWidth((Integer)width.second);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++c;
        }
    }

    public void optimizeColumnWidths(Object sampleType) {
        ArrayList<String> fields = BeanService.getPropertyNames(sampleType);
        int columnCount = this.getColumnCount();
        int c = 0;
        while (c < columnCount) {
            try {
                String fieldName = fields.get(c);
                Object value = BeanService.getPropertyValue(sampleType, fieldName);
                Pair<Integer, Integer> width = this.getOptimalColumnWidth(0, c, value, false, false);
                this.correctColumnWidth(width);
                TableColumn tc = this.getColumn(fieldName);
                tc.setWidth((Integer)width.first);
                tc.setPreferredWidth((Integer)width.second);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
            ++c;
        }
    }

    private void correctColumnWidth(Pair<Integer, Integer> width) {
        if ((Integer)width.first > this.maximumColumnWidth) {
            width.first = this.maximumColumnWidth;
        }
        if ((Integer)width.first < this.minimumColumnWidth) {
            width.first = this.minimumColumnWidth;
        }
        if ((Integer)width.second > this.maximumColumnWidth) {
            width.second = this.maximumColumnWidth;
        }
        if ((Integer)width.second < this.minimumColumnWidth) {
            width.second = this.minimumColumnWidth;
        }
    }

    public Pair<Integer, Integer> getOptimalColumnWidth(int row, int col, Object value, boolean isSelected, boolean hasFocus) {
        TableColumn column;
        int columnPreferredWidth;
        Component c;
        TableCellRenderer renderer = this.getCellRenderer(row, col);
        if (renderer == null) {
            if (this.proxyRenderer == null) {
                this.proxyRenderer = new TableCellEditorRenderer();
            }
            renderer = this.proxyRenderer;
        }
        if ((c = renderer.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, col)) == null) {
            return new Pair<Integer, Integer>(this.minimumColumnWidth, this.minimumColumnWidth);
        }
        int width = c.getWidth() + 10;
        int preferredWidth = (int)c.getPreferredSize().getWidth();
        if (c instanceof JComponent) {
            Insets insets;
            Insets bi;
            JComponent jc = (JComponent)c;
            Border border = jc.getBorder();
            if (border != null && (bi = border.getBorderInsets(jc)) != null) {
                preferredWidth += bi.left + bi.right;
            }
            if ((insets = jc.getInsets()) != null) {
                preferredWidth += insets.left + insets.right;
            }
        }
        if ((columnPreferredWidth = (column = this.columnModel.getColumn(col)).getPreferredWidth()) > preferredWidth) {
            preferredWidth = columnPreferredWidth;
        }
        return new Pair<Integer, Integer>(width, preferredWidth);
    }

    public void optimizeRowHeights() {
        int rowCount = this.getRowCount();
        int row = 0;
        while (row < rowCount) {
            this.setRowHeight(row, this.getOptimalRowHeight(row));
            ++row;
        }
    }

    public int getOptimalRowHeight(int row) {
        int columnCount = this.getColumnCount();
        int rowHeight = this.getRowHeight();
        int column = 0;
        while (column < columnCount) {
            Component comp = this.prepareRenderer(this.getCellRenderer(row, column), row, column);
            rowHeight = Math.max(rowHeight, comp.getPreferredSize().height);
            ++column;
        }
        return rowHeight + 4;
    }

    private void standardInit() {
        this.selectedRows = new int[0];
        this.rowInFocus = -1;
        this.cellInFocus = -1;
        this.printingEnabled = true;
        this.setDefaultRenderer(byte[].class, new ByteArrayTableCellRenderer());
        this.setDefaultRenderer(Timestamp.class, new TimestampTableCellRenderer());
        this.setDefaultRenderer(DateTime.class, new TimestampTableCellRenderer());
        JTableHeader tableHeader = this.getTableHeader();
        tableHeader.setBackground(UIManager.getColor("Table.foreground"));
        tableHeader.setForeground(UIManager.getColor("Table.background"));
        tableHeader.setFont(UIManager.getFont("Table.font").deriveFont(1));
        this.setRowHeight(25);
        this.setAutoCreateRowSorter(false);
        this.setAutoResizeMode(0);
        this.setFillsViewportHeight(true);
        this.addCellEditingListener(this);
    }

    public void removeAllColumns() {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        TableColumnModel tcm = this.getColumnModel();
        int cc = tcm.getColumnCount();
        int c = 0;
        while (c < cc) {
            TableColumn column = tcm.getColumn(c);
            columns.add(column);
            ++c;
        }
        for (TableColumn tableColumn : columns) {
            tcm.removeColumn(tableColumn);
        }
        this.rowInFocus = -1;
        this.cellInFocus = -1;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int lastRow;
        int firstRow = e.getFirstRow();
        if (Comparison.isBetween(this.rowInFocus, firstRow, lastRow = e.getLastRow())) {
            this.rowInFocus = -1;
            this.cellInFocus = -1;
        }
        super.tableChanged(e);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        if (listener == null) {
            return;
        }
        this.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        if (listener == null) {
            return;
        }
        this.getSelectionModel().removeListSelectionListener(listener);
    }

    public void addRowFocusListener(RowFocusListener listener) {
        if (listener == null) {
            return;
        }
        if (this.rowFocusListeners == null) {
            this.rowFocusListeners = new UniqueArrayList();
        }
        this.rowFocusListeners.add(listener);
    }

    public void removeRowFocusListener(RowFocusListener listener) {
        if (listener == null || CollectionUtility.isEmpty(this.rowFocusListeners)) {
            return;
        }
        this.rowFocusListeners.remove(listener);
    }

    public void addCellFocusListener(CellFocusListener listener) {
        if (listener == null) {
            return;
        }
        if (this.cellFocusListeners == null) {
            this.cellFocusListeners = new UniqueArrayList();
        }
        this.cellFocusListeners.add(listener);
    }

    public void removeCellFocusListener(CellFocusListener listener) {
        if (listener == null || CollectionUtility.isEmpty(this.cellFocusListeners)) {
            return;
        }
        this.cellFocusListeners.remove(listener);
    }

    public void addCellEditingListener(CellEditingListener listener) {
        if (listener == null) {
            return;
        }
        if (this.cellEditingListeners == null) {
            this.cellEditingListeners = new UniqueArrayList();
        }
        this.cellEditingListeners.add(listener);
    }

    public void removeCellEditingListener(CellEditingListener listener) {
        if (listener == null || CollectionUtility.isEmpty(this.cellEditingListeners)) {
            return;
        }
        this.cellEditingListeners.remove(listener);
    }

    private void notifyCellEditingListeners(int mode, int row, int column) {
        if (CollectionUtility.isEmpty(this.cellEditingListeners)) {
            return;
        }
        for (CellEditingListener listener : this.cellEditingListeners) {
            if (mode == 0) {
                listener.editingStarted(this, row, column);
                continue;
            }
            listener.editingStopped(this, row, column);
        }
    }

    public void addCellHoverListener(CellHoverListener listener) {
        if (listener == null) {
            return;
        }
        if (this.cellHoverListeners == null) {
            this.cellHoverListeners = new UniqueArrayList();
        }
        this.cellHoverListeners.add(listener);
    }

    public void removeCellHoverListeners(CellHoverListener listener) {
        if (listener == null || CollectionUtility.isEmpty(this.cellHoverListeners)) {
            return;
        }
        this.cellHoverListeners.remove(listener);
    }

    private void notifyCellHoverListeners() {
        if (CollectionUtility.isEmpty(this.cellHoverListeners)) {
            return;
        }
        for (CellHoverListener listener : this.cellHoverListeners) {
            listener.cellUnderCursor(this, this.rowUnderCursor, this.columnUnderCursor);
        }
    }

    @Override
    public void changeSelection(int row, int column, boolean toggle, boolean extend) {
        if ((this.cellInFocus != column || this.rowInFocus != row) && this.cellFocusListeners != null && this.cellFocusListeners.size() > 0) {
            CellFocusEvent event = new CellFocusEvent(this, this.rowInFocus, this.cellInFocus, row, column);
            for (CellFocusListener listener : this.cellFocusListeners) {
                new AsynchMethodInvoker((Object)listener, "cellFocusChange", (Object)event);
            }
        }
        if (this.isEditing) {
            this.notifyCellEditingListeners(1, row, column);
            this.isEditing = false;
        }
        this.rowInFocus = row;
        this.cellInFocus = column;
        super.changeSelection(row, column, toggle, extend);
        int[] selectedRows = this.getSelectedRows();
        if (!Arrays.equals(this.selectedRows, selectedRows) && this.rowFocusListeners != null && this.rowFocusListeners.size() > 0) {
            RowFocusEvent event = new RowFocusEvent(this, this.rowInFocus, row);
            for (RowFocusListener listener : this.rowFocusListeners) {
                new AsynchMethodInvoker((Object)listener, "rowFocusChange", (Object)event);
            }
        }
        this.selectedRows = selectedRows;
        if (this.editCellAt(row, column)) {
            this.isEditing = true;
            this.notifyCellEditingListeners(0, row, column);
            Component editor = this.getEditorComponent();
            if (editor != null) {
                editor.requestFocusInWindow();
            }
        }
    }

    @Override
    public int getSelectedRow() {
        int row = super.getSelectedRow();
        if (row == -1) {
            return row;
        }
        int selectedRow = this.convertRowIndexToModel(row);
        return selectedRow;
    }

    @Override
    public int[] getSelectedRows() {
        int[] rows = super.getSelectedRows();
        if (rows.length == 0) {
            return rows;
        }
        int[] selectedRows = new int[rows.length];
        int i = 0;
        while (i < rows.length) {
            selectedRows[i] = this.convertRowIndexToModel(rows[i]);
            ++i;
        }
        return selectedRows;
    }

    public void setSelectedRows(int[] rows, boolean convertToView) {
        int rowCount = this.getRowCount();
        ListSelectionModel model = this.getSelectionModel();
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            if (row >= 0 && row < rowCount) {
                int realRow = convertToView ? this.convertRowIndexToView(row) : row;
                model.addSelectionInterval(realRow, realRow);
            }
            ++n2;
        }
    }

    public void invertEditorColors(int row, int column) {
        TableCellEditorRenderer editorRenderer;
        Component component;
        TableCellEditor editor = this.getCellEditor(row, column);
        if (editor != null && editor instanceof TableCellEditorRenderer && (component = (editorRenderer = (TableCellEditorRenderer)editor).getTableCellEditorComponent(this, this.getValueAt(row, column), true, row, column)) instanceof JTextField) {
            JTextField textField = (JTextField)component;
            Color fg = UIManager.getColor("Textfield.foreground");
            Color bg = UIManager.getColor("Textfield.background");
            textField.setForeground(bg);
            textField.setBackground(fg);
        }
    }

    @Override
    public void editingStarted(JTable table, int row, int column) {
        this.invertEditorColors(row, column);
    }

    @Override
    public void editingStopped(JTable table, int row, int column) {
        this.commitEdits();
    }

    public void commitEdits() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    public boolean isPrintingEnabled() {
        return this.printingEnabled;
    }

    public void setPrintingEnabled(boolean printingEnabled) {
        this.printingEnabled = printingEnabled;
    }

    public boolean filePrintEnabled() {
        if (!this.printingEnabled) {
            return false;
        }
        return this.getModel().getRowCount() > 0;
    }

    public void filePrint() {
        try {
            this.commitEdits();
            this.print();
        }
        catch (PrinterException e) {
            new ExceptionDialog((Window)GUIServices.getFrame(this), "Printing Error", "There was an error attempting to print the table's contents.", e);
        }
    }

    public void fileExport() {
        File outputFile = GUIServices.fileSaveDialog(null);
        if (outputFile == null) {
            return;
        }
        this.commitEdits();
        try {
            FileOutputStream fout = new FileOutputStream(outputFile);
            ExcelTableModelExport tableModelExport = new ExcelTableModelExport(this);
            tableModelExport.setWorksheetName(outputFile.getName());
            tableModelExport.exportTo(fout);
            fout.flush();
            fout.close();
        }
        catch (FileNotFoundException e) {
            new ExceptionDialog((Window)GUIServices.getFrame(this), "File not found!", "There was an error attempting to export the table's contents to " + outputFile.getName() + ". The file was not found.", e);
        }
        catch (IOException e) {
            new ExceptionDialog((Window)GUIServices.getFrame(this), "Error During Export", "There was an error attempting to export the table's contents to " + outputFile.getName(), e);
        }
    }

    public void deleteSelected(String confirmationTitle, String confirmationMessage) {
        if (this.getRowCount() == 0 || this.getSelectedRowCount() == 0) {
            return;
        }
        new JMMessageBox(GUIServices.getFrame(this), confirmationTitle, confirmationMessage, 12);
        if (JMMessageBox.getSelection() == 8) {
            return;
        }
        this.commitEdits();
        int[] selectedRows = this.getSelectedRows();
        Arrays.sort(selectedRows);
        this.clearSelection();
        TableModel tableModel = this.getModel();
        String modelType = tableModel.getClass().getSimpleName();
        int r = selectedRows.length - 1;
        while (r >= 0) {
            switch (modelType) {
                case "BeanTableModel": {
                    BeanTableModel btm = (BeanTableModel)tableModel;
                    btm.deleteRow(selectedRows[r]);
                    break;
                }
                case "DynamicBeanTableModel": {
                    DynamicBeanTableModel dbtm = (DynamicBeanTableModel)tableModel;
                    dbtm.deleteRow(selectedRows[r]);
                    break;
                }
                case "DefaultTableModel": {
                    DefaultTableModel dtm = (DefaultTableModel)tableModel;
                    dtm.removeRow(selectedRows[r]);
                }
            }
            --r;
        }
    }
}

