/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.awt.ShapeCreator;
import com.jmorgan.awt.ShapePainter;
import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.FocusChangePropertyChangeNotifier;
import com.jmorgan.util.StringUtility;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public class JMTextArea
extends JTextArea
implements PropertyChangeNotifier {
    protected PropertyChangeSupport propertyChangeSupport;
    private ShapeCreator shapeCreator;
    private ShapePainter shapePainterDelegate;
    private Insets insets;
    private boolean isNull;
    private String nullRenderValue;
    private String oldValue;
    private UndoManager undoManager;

    public JMTextArea() {
        this.standardInit();
    }

    public JMTextArea(Document document) {
        super(document);
        this.standardInit();
    }

    public JMTextArea(Document document, String text, int rows, int columns) {
        super(document, text, rows, columns);
        this.standardInit();
    }

    public JMTextArea(int rows, int columns) {
        super(rows, columns);
        this.standardInit();
    }

    public JMTextArea(String text) {
        super(text);
        this.standardInit();
    }

    public JMTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.standardInit();
    }

    @Override
    public void setText(String newText) {
        this.oldValue = this.getText();
        if (this.oldValue == null) {
            this.oldValue = "";
        }
        if (newText == null && this.isNull || newText != null && newText.equals(this.oldValue)) {
            return;
        }
        this.setNull(newText == null);
        super.setText(newText);
    }

    public void clearSelection() {
        if (!StringUtility.isEmpty(this.getText())) {
            this.setSelectionStart(0);
            this.setSelectionEnd(0);
        }
    }

    public boolean isNull() {
        return this.isNull;
    }

    public void setNull(boolean isNull) {
        if (this.isNull == isNull) {
            return;
        }
        this.isNull = isNull;
        if (this.isNull) {
            super.setText(this.nullRenderValue);
        }
        Font font = this.getFont();
        this.setFont(font.deriveFont(this.isNull ? 2 : 0));
    }

    public String getNullRenderValue() {
        return this.nullRenderValue;
    }

    public void setNullRenderValue(String nullRenderValue) {
        this.nullRenderValue = nullRenderValue;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setPreferredSize(int height, int width) {
        this.setPreferredSize(new Dimension(height, width));
    }

    @Override
    public Insets getInsets() {
        if (this.insets == null) {
            return super.getInsets();
        }
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    public void setMargin(Insets m) {
        super.setMargin(m);
        this.setInsets(m);
    }

    public ShapeCreator getShapeCreator() {
        return this.shapeCreator;
    }

    public void setShapeCreator(ShapeCreator shapeCreator) {
        this.shapePainterDelegate = null;
        this.shapeCreator = shapeCreator;
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.shapeCreator != null) {
            if (this.shapePainterDelegate == null) {
                this.shapePainterDelegate = new ShapePainter(this, this.shapeCreator.createShape(this.getBounds()));
            }
            this.shapePainterDelegate.paintBorder(g);
        } else {
            super.paintBorder(g);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        if (this.shapeCreator != null) {
            if (this.shapePainterDelegate == null) {
                this.shapePainterDelegate = new ShapePainter(this, this.shapeCreator.createShape(this.getBounds()));
            }
            this.shapePainterDelegate.paintComponent(g);
        }
        super.paintComponent(g);
    }

    @Reflected
    public void editUndo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    @Reflected
    public void editRedo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    void standardInit() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.oldValue = this.getText();
        this.propertyChangeSupport = ComponentFactory.textComponentInitHelper(this, "text", "TextArea.shapeCreator");
        new FocusChangePropertyChangeNotifier(this);
        CompoundBorder border = BorderFactory.createCompoundBorder(this.getBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setBorder(border);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    public void firePropertyChange(String oldText, String newText) {
        if (this.propertyChangeSupport != null) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, this.getName(), oldText, newText);
            PropertyChangeListener[] propertyChangeListenerArray = this.propertyChangeSupport.getPropertyChangeListeners();
            int n = propertyChangeListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeListener listener = propertyChangeListenerArray[n2];
                listener.propertyChange(pce);
                ++n2;
            }
        }
    }
}

