/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.awt.ShapeCreator;
import com.jmorgan.awt.ShapePainter;
import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.FocusChangePropertyChangeNotifier;
import com.jmorgan.util.StringUtility;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public class JMTextField
extends JTextField
implements PropertyChangeNotifier,
Customizer {
    protected PropertyChangeSupport propertyChangeSupport;
    private ShapeCreator shapeCreator;
    private ShapePainter shapePainterDelegate;
    private boolean isNull;
    private String nullRenderValue;
    private UndoManager undoManager;
    private Border border;

    public JMTextField() {
        this.standardInit();
    }

    public JMTextField(String text) {
        super(text);
        this.standardInit();
    }

    public JMTextField(int columns) {
        super(columns);
        this.standardInit();
    }

    public JMTextField(String text, int columns) {
        super(text, columns);
        this.standardInit();
    }

    public JMTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.standardInit();
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void setText(String newText) {
        String oldText = this.getText();
        if (newText == null && this.isNull || newText != null && newText.equals(oldText)) {
            return;
        }
        this.setNull(newText == null);
        super.setText(newText);
        this.firePropertyChange(oldText, newText);
    }

    public boolean isNull() {
        return this.isNull;
    }

    public void setNull(boolean isNull) {
        if (this.isNull == isNull) {
            return;
        }
        this.isNull = isNull;
        if (this.isNull) {
            super.setText(this.nullRenderValue);
        }
        Font font = this.getFont();
        this.setFont(font.deriveFont(this.isNull ? 2 : 0));
    }

    public String getNullRenderValue() {
        return this.nullRenderValue;
    }

    public void setNullRenderValue(String nullRenderValue) {
        this.nullRenderValue = nullRenderValue;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public ShapeCreator getShapeCreator() {
        return this.shapeCreator;
    }

    public void setShapeCreator(ShapeCreator shapeCreator) {
        this.shapePainterDelegate = null;
        this.shapeCreator = shapeCreator;
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (this.shapeCreator != null) {
            if (this.shapePainterDelegate == null) {
                this.shapePainterDelegate = new ShapePainter(this, this.shapeCreator.createShape(this.getBounds()));
            }
            this.shapePainterDelegate.paintBorder(g);
        } else {
            super.paintBorder(g);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.isEnabled() ? this.getBackground() : UIManager.getColor("TextField.inactiveBackground"));
        if (this.shapeCreator != null) {
            if (this.shapePainterDelegate == null) {
                this.shapePainterDelegate = new ShapePainter(this, this.shapeCreator.createShape(this.getBounds()));
            }
            this.shapePainterDelegate.paintComponent(g);
        }
        super.paintComponent(g);
    }

    public void firePropertyChange(String oldText, String newText) {
        if (this.propertyChangeSupport != null && oldText != null && !oldText.equals(newText)) {
            String fieldName = this.getName();
            this.propertyChangeSupport.firePropertyChange(StringUtility.isEmpty(fieldName) ? "text" : fieldName, oldText, newText);
        }
    }

    @Override
    public void setObject(Object value) {
        this.setText((String)value);
    }

    protected void standardInit() {
        this.nullRenderValue = "-null-";
        this.propertyChangeSupport = ComponentFactory.textComponentInitHelper(this, "text", "TextField.shapeCreator");
        new FocusChangePropertyChangeNotifier(this);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }
}

