/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.annotations.Reflected;
import java.awt.Dimension;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;

public class JMTextPane
extends JTextPane {
    private UndoManager undoManager;

    public JMTextPane() {
        this.standardInit();
    }

    public JMTextPane(StyledDocument doc) {
        super(doc);
        this.standardInit();
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    @Reflected
    public void editUndo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    @Reflected
    public void editRedo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    private void standardInit() {
        Document doc = this.getDocument();
        this.undoManager = new UndoManager();
        doc.addUndoableEditListener(this.undoManager);
    }
}

