/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;

public class LabeledComponent
extends JMPanel {
    private static final int FIXED_HEIGHT = 25;
    private Component label;
    private Component component;
    private int labelLocation;
    private int fixedLabelWidth;
    private int fixedComponentWidth;

    public LabeledComponent() {
    }

    public LabeledComponent(String label, Component component) {
        this(label, component, 2, 0, 0);
    }

    public LabeledComponent(String label, Component component, int labelWidth, int componentWidth) {
        this(label, component, 2, labelWidth, componentWidth);
    }

    public LabeledComponent(String label, Component component, int labelLocation) {
        this(label, component, labelLocation, 0, 0);
    }

    public LabeledComponent(String label, Component component, int labelLocation, int labelWidth, int componentWidth) {
        this(new JLabel(label), component, labelLocation, labelWidth, componentWidth);
    }

    public LabeledComponent(Component label, Component component) {
        this(label, component, 2, 0, 0);
    }

    public LabeledComponent(Component label, Component component, int labelWidth, int componentWidth) {
        this(label, component, 2, labelWidth, componentWidth);
    }

    public LabeledComponent(Component label, Component component, int labelLocation) {
        this(label, component, labelLocation, 0, 0);
    }

    public LabeledComponent(Component label, Component component, int labelLocation, int labelWidth, int componentWidth) {
        super(new BorderLayout(5, 10));
        this.labelLocation = -10;
        this.setFixedLabelWidth(labelWidth);
        this.setFixedComponentWidth(componentWidth);
        this.setLabelLocation(labelLocation);
        this.setComponent(component);
        this.setLabel(label);
        this.layoutComponent();
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        if (component == null) {
            throw new NullPointerException("The component in LabeledComponent.setComponent() cannot be null.");
        }
        Component oldComponent = this.component;
        this.component = component;
        if (this.fixedComponentWidth != 0) {
            this.component.setPreferredSize(new Dimension(this.fixedComponentWidth, 25));
            this.component.setSize(this.fixedComponentWidth, 25);
        }
        if (oldComponent != null) {
            this.layoutComponent();
        }
    }

    public Component getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label == null) {
            throw new NullPointerException("The label in LabeledComponent.setLabel(String label) cannot be null");
        }
        this.setLabel(new JMLabel(label));
    }

    public void setLabel(Component label) {
        if (label == null) {
            throw new NullPointerException("The compoment label in LabeledComponent.setLabel(Component label) cannot be null");
        }
        Component oldLable = this.label;
        this.label = label;
        if (this.fixedLabelWidth != 0) {
            this.label.setPreferredSize(new Dimension(this.fixedLabelWidth, 25));
            this.label.setSize(this.fixedLabelWidth, 25);
        }
        if (oldLable != null) {
            this.layoutComponent();
        }
    }

    public int getLabelLocation() {
        return this.labelLocation;
    }

    public void setLabelLocation(int labelLocation) {
        int oldLabelLocation = this.labelLocation;
        switch (labelLocation) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.labelLocation = labelLocation;
                break;
            }
            default: {
                throw new IllegalArgumentException("The value of " + labelLocation + " for label location in LabeledComponent.setLabelLocation() is invalid.");
            }
        }
        if (oldLabelLocation != -10) {
            this.layoutComponent();
        }
    }

    public int getFixedLabelWidth() {
        return this.fixedLabelWidth;
    }

    public void setFixedLabelWidth(int fixedLabelWidth) {
        this.fixedLabelWidth = fixedLabelWidth;
    }

    public int getFixedComponentWidth() {
        return this.fixedComponentWidth;
    }

    public void setFixedComponentWidth(int fixedComponentWidth) {
        this.fixedComponentWidth = fixedComponentWidth;
    }

    private void layoutComponent() {
        this.remove(this.component);
        this.remove(this.label);
        String labelLocation = null;
        switch (this.labelLocation) {
            case 1: {
                labelLocation = "North";
                break;
            }
            case 3: {
                labelLocation = "South";
                break;
            }
            case 2: {
                labelLocation = "West";
                break;
            }
            case 4: {
                labelLocation = "East";
            }
        }
        if (this.label instanceof JLabel) {
            ((JLabel)this.label).setLabelFor(this.component);
        }
        this.add(this.label, labelLocation);
        this.add(this.component, "Center");
    }
}

