/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.io.SystemPrintStreamInterceptor;
import com.jmorgan.io.SystemPrintStreamListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTextArea;
import com.jmorgan.swing.MainPanel;
import com.jmorgan.swing.event.ActionEventInvoker;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.PrintStream;

public class SystemOutDisplayPanel
extends MainPanel
implements SystemPrintStreamListener {
    private JMTextArea textArea;
    private JMButton clearButton;

    public SystemOutDisplayPanel(boolean forwardMessages) {
        SystemPrintStreamInterceptor out = new SystemPrintStreamInterceptor(System.out, forwardMessages);
        out.addPrintStreamListener(this);
        SystemPrintStreamInterceptor err = new SystemPrintStreamInterceptor(System.err, forwardMessages);
        err.addPrintStreamListener(this);
        this.textArea = new JMTextArea();
        this.add(new JMScrollPane(this.textArea));
        this.clearButton = new JMButton("&Clear Output");
        new ActionEventInvoker(this.clearButton, this, "clearMessages");
        JMPanel panel = new JMPanel();
        panel.add(this.clearButton);
        this.add((Component)panel, "South");
    }

    public void addActionListener(ActionListener listener) {
        this.clearButton.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.clearButton.removeActionListener(listener);
    }

    public void clearMessages() {
        this.textArea.setText("");
    }

    @Override
    public void messageIntercepted(PrintStream stream, String message) {
        String newText = this.textArea.getText() + message;
        this.textArea.setText(newText);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }
}

