/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.swing.JMFormattedTextField;
import com.jmorgan.util.Date;
import com.jmorgan.util.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class TimeField
extends JMFormattedTextField {
    public static final String HHMM_24_FORMAT = "HH:mm";
    public static final String HHMMSS_24_FORMAT = "HH:mm:ss";
    public static final String HHMM_12_FORMAT = "hh:mm a";
    public static final String HHMMSS_12_FORMAT = "hh:mm:ss a";
    private String formatString;
    private int mode;

    public TimeField() {
        this(new GregorianCalendar());
    }

    public TimeField(Calendar time) {
        this.setFormatString(HHMMSS_24_FORMAT);
        this.setTime(time);
    }

    public TimeField(Time time) {
        this(time.getCalendar());
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        if (this.propertyChangeSupport != null) {
            this.firePropertyChange("formatString", this.formatString, formatString);
        }
        this.formatString = formatString;
        DateFormatter tf = new DateFormatter(new SimpleDateFormat(formatString));
        tf.setCommitsOnValidEdit(true);
        this.setFormatterFactory(new DefaultFormatterFactory(tf, tf, tf, tf));
        this.formatString = formatString;
        this.mode = formatString.indexOf(97) >= 0 ? 12 : 24;
    }

    public int getMode() {
        return this.mode;
    }

    public Calendar getTime() {
        if (this.isNull()) {
            return null;
        }
        Date t = new Date((java.util.Date)this.getValue());
        return t.getCalendar();
    }

    public void setTime(Calendar time) {
        this.setValue(time.getTime());
    }
}

