/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.border;

import com.jmorgan.swing.util.InsetsFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class RoundedCornerBorder
extends AbstractBorder
implements UIResource {
    public static final int SOLID_STYLE = 0;
    public static final int ETCHED_STYLE = 1;
    public static final int RAISED_STYLE = 2;
    public static final int LOWERED_STYLE = 3;
    private Color color;
    private int thickness;
    private int cornerSize;
    private int borderStyle;
    private Stroke oldStroke;

    public RoundedCornerBorder() {
        this(10);
    }

    public RoundedCornerBorder(int cornerSize) {
        this(0, cornerSize);
    }

    public RoundedCornerBorder(int style, int cornerSize) {
        this(style, cornerSize, 1);
    }

    public RoundedCornerBorder(int style, int cornerSize, int thickness) {
        this(null, style, cornerSize, thickness);
    }

    public RoundedCornerBorder(Color color) {
        this(color, 10);
    }

    public RoundedCornerBorder(Color color, int cornerSize) {
        this(color, 0, cornerSize);
    }

    public RoundedCornerBorder(Color color, int style, int cornerSize) {
        this(color, style, cornerSize, 1);
    }

    public RoundedCornerBorder(Color color, int style, int cornerSize, int thickness) {
        this.setColor(color);
        this.setBorderStyle(style);
        this.setThickness(thickness);
        this.setCornerSize(cornerSize);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    public void setCornerSize(int cornerSize) {
        this.cornerSize = cornerSize;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int borderStyle) {
        switch (borderStyle) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.borderStyle = borderStyle;
                break;
            }
            default: {
                this.borderStyle = 0;
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return InsetsFactory.createFixedInsets(this.thickness);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return InsetsFactory.createFixedInsets(this.thickness);
    }

    @Override
    public Rectangle getInteriorRectangle(Component c, int x, int y, int width, int height) {
        int left = this.cornerSize + this.thickness;
        int right = this.cornerSize * 2 + this.thickness * 2;
        return new Rectangle(x + left, y + left, width - right, height - right);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        boolean colorWasNull = false;
        if (this.color == null) {
            colorWasNull = true;
            this.color = c.getBackground();
        }
        Color oldColor = g.getColor();
        g.setColor(this.color);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int thicknessAdjust = this.thickness / 2;
        x += thicknessAdjust;
        y += thicknessAdjust;
        width -= this.thickness;
        height -= this.thickness;
        switch (this.borderStyle) {
            case 1: {
                this.paintBorderEtched(g, x, y, width, height);
                break;
            }
            case 2: {
                this.paintBorderRaised(g, x, y, width, height);
                break;
            }
            case 3: {
                this.paintBorderLowered(g, x, y, width, height);
                break;
            }
            default: {
                this.paintBorderSolid(g, x, y, width, height);
            }
        }
        g.setColor(oldColor);
        if (colorWasNull) {
            this.color = null;
        }
    }

    private void paintBorderSolid(Graphics g, int x, int y, int width, int height) {
        g.setColor(this.color);
        this.saveStroke(g);
        g.drawRoundRect(x, y, width, height, this.cornerSize, this.cornerSize);
        this.restoreStroke(g);
    }

    private void paintBorderEtched(Graphics g, int x, int y, int width, int height) {
        Color[] colors = new Color[]{this.color.darker(), this.color.brighter()};
        int w = width - 1 - this.thickness * 2;
        int h = height - 1 - this.thickness * 2;
        this.saveStroke(g);
        int c = 0;
        while (c < colors.length) {
            g.setColor(colors[c]);
            g.drawRoundRect(x + this.thickness, y += this.thickness, w, h, this.cornerSize, this.cornerSize);
            ++c;
        }
        this.restoreStroke(g);
    }

    private void paintBorderRaised(Graphics g, int x, int y, int width, int height) {
        Color[] colors = new Color[]{this.color.darker().darker(), this.color.darker()};
        this.paintBorderRaisedLowered(colors, g, x, y, width, height);
    }

    private void paintBorderLowered(Graphics g, int x, int y, int width, int height) {
        Color[] colors = new Color[]{this.color.brighter().brighter(), this.color.brighter()};
        this.paintBorderRaisedLowered(colors, g, x, y, width, height);
    }

    private void paintBorderRaisedLowered(Color[] colors, Graphics g, int x, int y, int width, int height) {
        int w = width - 1;
        int h = height - 1;
        this.saveStroke(g);
        int c = 0;
        while (c < colors.length) {
            g.setColor(colors[c]);
            g.drawRoundRect(x += this.thickness, y += this.thickness, w -= this.thickness, h -= this.thickness, this.cornerSize, this.cornerSize);
            ++c;
        }
        this.restoreStroke(g);
    }

    private void saveStroke(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.oldStroke = g2d.getStroke();
        if (this.thickness > 1) {
            g2d.setStroke(new BasicStroke(this.thickness));
        }
    }

    private void restoreStroke(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setStroke(this.oldStroke);
    }
}

