/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar;

import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.calendar.CalendarSelectionListener;
import com.jmorgan.swing.calendar.DayContainer;
import com.jmorgan.swing.calendar.model.CalendarModel;
import com.jmorgan.swing.util.ComponentConstants;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.DateMetaData;
import com.jmorgan.util.DynamicClassLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.geom.Rectangle2D;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.border.LineBorder;

public class MonthDetail
extends JMPanel
implements CalendarSelectionListener {
    private DayContainer[] days;
    private static int HEADERPANELS = 7;
    private static int DAYPANELS = 42;
    private CalendarModel calendarModel;

    MonthDetail(String dayContainerClassName) throws ClassNotFoundException {
        this(Class.forName(dayContainerClassName));
    }

    MonthDetail(Class dayContainerClass) {
        JMPanel topPanel = new JMPanel(new GridLayout(1, 7));
        JMPanel bottomPanel = new JMPanel(new GridLayout(6, 7));
        this.setLayout(new BorderLayout());
        this.setBackground(Color.LIGHT_GRAY);
        this.setBorder(new LineBorder(Color.BLACK));
        this.days = new DayContainer[DAYPANELS];
        Calendar today = Calendar.getInstance();
        int i = 0;
        while (i < DAYPANELS) {
            try {
                this.days[i] = (DayContainer)DynamicClassLoader.createObjectFromClass(dayContainerClass);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            this.days[i].addCalendarSelectionListener(this);
            this.days[i].setSelectedDate(today);
            bottomPanel.add(this.days[i].getUIComponent());
            ++i;
        }
        Dimension componentSize = this.days[0].getUIComponent().getPreferredSize();
        Rectangle2D displaySize = GUIServices.getFontDisplaySize(DateMetaData.getDayOfWeek(4, 10), ComponentConstants.textFont);
        int maxWidth = (int)displaySize.getWidth();
        int titleMode = componentSize.width < maxWidth ? 3 : 10;
        int i2 = 0;
        while (i2 < HEADERPANELS) {
            JMLabel dayH = new JMLabel(DateMetaData.getDayOfWeek(i2, titleMode), 0);
            dayH.setBorder(ComponentConstants.controlBorder);
            topPanel.add(dayH);
            ++i2;
        }
        this.add((Component)topPanel, "North");
        this.add((Component)bottomPanel, "Center");
    }

    private void clearDays() {
        int i = 0;
        while (i < DAYPANELS) {
            this.days[i].setDate(null, null);
            ++i;
        }
    }

    public void setCalendarModel(CalendarModel model) {
        this.calendarModel = model;
        int i = 0;
        while (i < DAYPANELS) {
            this.days[i].setCalendarModel(this.calendarModel);
            ++i;
        }
    }

    void setDate(Calendar selectedDate) {
        this.clearDays();
        int month = selectedDate.get(2);
        int year = selectedDate.get(1);
        GregorianCalendar dateToShow = new GregorianCalendar(year, month, 1);
        while (dateToShow.get(7) != 1) {
            ((Calendar)dateToShow).add(5, -1);
        }
        int i = 0;
        while (i < 42) {
            Calendar thisDate = (Calendar)((Calendar)dateToShow).clone();
            this.days[i].setDate(thisDate, selectedDate);
            ((Calendar)dateToShow).add(5, 1);
            ++i;
        }
    }

    public void addCalendarSelectionListener(CalendarSelectionListener listener) {
        int i = 0;
        while (i < this.days.length) {
            this.days[i].addCalendarSelectionListener(listener);
            ++i;
        }
    }

    public DayContainer[] getDayPanels() {
        return this.days;
    }

    @Override
    public void dateSelected(Calendar date) {
        this.setDate(date);
    }
}

