/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar.model;

import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.swing.calendar.model.RecurrencePattern;
import com.jmorgan.util.Date;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public abstract class CalendarEntry
implements Serializable,
PropertyChangeNotifier {
    private String title;
    private String description;
    private Date startDate;
    private Date endDate;
    private RecurrencePattern recurrencePattern;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public CalendarEntry() {
        this(new Date());
    }

    public CalendarEntry(Date startDate) {
        this.setStartDate(startDate);
    }

    public boolean existsFor(Date date) {
        Date surrogateEndDate;
        Date date2 = surrogateEndDate = this.endDate == null ? this.startDate : this.endDate;
        if (!date.isBetween(this.startDate, surrogateEndDate)) {
            return false;
        }
        return this.recurrencePattern == null || this.recurrencePattern.isValidDate(date);
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public String getTitle() {
        return this.title == null ? "" : this.title;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean hasRecurrencePattern() {
        return this.recurrencePattern == null;
    }

    public RecurrencePattern getRecurrencePattern() {
        return this.recurrencePattern;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStartDate(Date date) {
        Date oldStartDate = date;
        this.startDate = date;
        this.propertyChangeSupport.firePropertyChange("startDate", oldStartDate, date);
    }

    public void setEndDate(Date date) {
        Date oldEndDate = this.endDate;
        this.endDate = date;
        this.propertyChangeSupport.firePropertyChange("endDate", oldEndDate, this.endDate);
    }

    public void setRecurrencePattern(RecurrencePattern recurrencePattern) {
        RecurrencePattern oldPattern = this.recurrencePattern;
        this.recurrencePattern = recurrencePattern;
        this.propertyChangeSupport.firePropertyChange("recurrencePattern", oldPattern, recurrencePattern);
    }

    public void setRecurrencePatternType(int type) throws IllegalArgumentException {
        Date startDate = this.startDate;
        int frequency = 1;
        long duration = 1L;
        if (this.recurrencePattern != null) {
            startDate = this.recurrencePattern.getStartDate();
            frequency = this.recurrencePattern.getRecurrenceFrequency();
            duration = this.recurrencePattern.getDuration();
        }
        RecurrencePattern oldPattern = this.recurrencePattern;
        this.recurrencePattern = RecurrencePattern.getInstance(startDate, frequency, type);
        this.recurrencePattern.setDuration((int)duration);
        this.propertyChangeSupport.firePropertyChange("recurrencePattern", oldPattern, this.recurrencePattern);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String toString() {
        return "Title: " + this.title + "\nDescription: " + this.description + "\nStart Date: " + String.valueOf(this.startDate) + (String)(this.endDate == null ? "" : "\nEnd Date: " + String.valueOf(this.endDate)) + "\n" + String.valueOf(this.recurrencePattern);
    }
}

