/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar.model;

import com.jmorgan.swing.calendar.model.RecurrencePattern;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateMetaData;

public class DailyRecurrencePattern
extends RecurrencePattern {
    public DailyRecurrencePattern(Date startDate) {
        super(startDate);
    }

    public DailyRecurrencePattern(Date startDate, int frequency) {
        super(startDate, frequency);
    }

    public boolean isOnlyWeekdays() {
        return !this.isUsingFrequency();
    }

    public void setOnlyOnWeekdays(boolean state) {
        if (state) {
            this.useAlternate();
        }
    }

    @Override
    public boolean isValidDate(Date date) {
        if (!super.isValidDate(date)) {
            return false;
        }
        int freq = this.getRecurrenceFrequency();
        Date start = (Date)this.getStartDate().clone();
        while (start.isBefore(date)) {
            start.addDays(freq);
        }
        if (!start.equals(date)) {
            return false;
        }
        if (this.isOnlyWeekdays()) {
            return DateMetaData.isWeekday(date.getCalendar());
        }
        return false;
    }
}

