/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar.model;

import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.swing.calendar.model.Appointment;
import com.jmorgan.swing.calendar.model.CalendarEntry;
import com.jmorgan.swing.calendar.model.CalendarModel;
import com.jmorgan.swing.calendar.model.Event;
import com.jmorgan.swing.calendar.model.Task;
import com.jmorgan.util.Date;
import com.jmorgan.util.collection.InstanceSelector;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;

public class DefaultCalendarModel
implements CalendarModel {
    private ArrayList<CalendarEntry> entries = new ArrayList();
    private InstanceSelector<CalendarEntry> instanceSelector = new InstanceSelector<CalendarEntry>(this.entries, CalendarEntry.class);
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Collection<? extends CalendarEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(CalendarEntry entry) {
        this.entries.add(entry);
        if (entry instanceof Appointment) {
            this.propertyChangeSupport.firePropertyChange("appointment", null, entry);
        }
        if (entry instanceof Event) {
            this.propertyChangeSupport.firePropertyChange("event", null, entry);
        }
        if (entry instanceof Task) {
            this.propertyChangeSupport.firePropertyChange("task", null, entry);
        }
    }

    public void addAppointment(Appointment appt) {
        this.addEntry(appt);
    }

    public void addEvent(Event evt) {
        this.addEntry(evt);
    }

    public void addTask(Task task) {
        this.addEntry(task);
    }

    public void removeEntry(CalendarEntry entry) {
        this.entries.remove(entry);
        if (entry instanceof Appointment) {
            this.propertyChangeSupport.firePropertyChange("appointment", entry, null);
        }
        if (entry instanceof Event) {
            this.propertyChangeSupport.firePropertyChange("event", entry, null);
        }
        if (entry instanceof Task) {
            this.propertyChangeSupport.firePropertyChange("task", entry, null);
        }
    }

    public void removeAppointment(Appointment appt) {
        this.removeEntry(appt);
    }

    public void removeEvent(Event evt) {
        this.removeEntry(evt);
    }

    public void removeTask(Task task) {
        this.removeEntry(task);
    }

    private <T extends CalendarEntry> Collection<T> getEntries(Class<T> type) {
        this.instanceSelector.setInstanceType(type);
        return this.instanceSelector.getSelectedElements();
    }

    private boolean hasEntry(Class<?> type, Date date) {
        return this.getEntries(type, date).size() > 0;
    }

    @Override
    public boolean hasAppointment(Date date) {
        return this.hasEntry(Appointment.class, date);
    }

    @Override
    public boolean hasEvent(Date date) {
        return this.hasEntry(Event.class, date);
    }

    @Override
    public boolean hasTask(Date date) {
        return this.hasEntry(Task.class, date);
    }

    @Override
    public boolean entryExists(Object entry) {
        return this.entries.contains(entry);
    }

    private Collection<CalendarEntry> getEntries(Class<? extends CalendarEntry> type, Date date) {
        ArrayList<CalendarEntry> matches = new ArrayList<CalendarEntry>();
        Collection<? extends CalendarEntry> entries = this.getEntries(type);
        for (CalendarEntry calendarEntry : entries) {
            if (!calendarEntry.existsFor(date)) continue;
            matches.add(calendarEntry);
        }
        return matches;
    }

    @Override
    public Collection<Appointment> getAppointments(Date date) {
        Collection<CalendarEntry> entries = this.getEntries(Appointment.class, date);
        ArrayList<Appointment> list = new ArrayList<Appointment>();
        for (CalendarEntry entry : entries) {
            list.add((Appointment)entry);
        }
        return list;
    }

    @Override
    public Collection<Event> getEvents(Date date) {
        Collection<CalendarEntry> entries = this.getEntries(Event.class, date);
        ArrayList<Event> list = new ArrayList<Event>();
        for (CalendarEntry entry : entries) {
            list.add((Event)entry);
        }
        return list;
    }

    @Override
    public Collection<Task> getTasks(Date date) {
        Collection<CalendarEntry> entries = this.getEntries(Task.class, date);
        ArrayList<Task> list = new ArrayList<Task>();
        for (CalendarEntry entry : entries) {
            list.add((Task)entry);
        }
        return list;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

