/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.chart.renderer;

import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.renderer.category.BarRenderer;

public class Gradient3DBarRenderer
extends BarRenderer {
    private Color startingColor;
    private Color endingColor;
    private int startingRed;
    private int startingGreen;
    private int startingBlue;
    private int startingAlpha;
    private int endingRed;
    private int endingGreen;
    private int endingBlue;
    private int endingAlpha;

    public Gradient3DBarRenderer() {
        this(new Color(224, 224, 255), Color.BLUE);
    }

    public Gradient3DBarRenderer(Color startingColor, Color endingColor) {
        this.setStartingColor(startingColor);
        this.setEndingColor(endingColor);
    }

    public Color getStartingColor() {
        return this.startingColor;
    }

    public void setStartingColor(Color startingColor) throws IllegalArgumentException {
        if (this.startingColor == null && startingColor == null) {
            throw new IllegalArgumentException("The given starting color for " + this.getClass().getName() + ".setStartingColor(Color) is not allowed to be null if the value has not been previously set.");
        }
        if (startingColor == null) {
            return;
        }
        this.startingColor = startingColor;
        this.startingRed = this.startingColor.getRed();
        this.startingGreen = this.startingColor.getGreen();
        this.startingBlue = this.startingColor.getBlue();
        this.startingAlpha = this.startingColor.getAlpha();
    }

    public Color getEndingColor() {
        return this.endingColor;
    }

    public void setEndingColor(Color endingColor) throws IllegalArgumentException {
        if (this.endingColor == null && endingColor == null) {
            throw new IllegalArgumentException("The given ending color for " + this.getClass().getName() + ".setEndingColor(Color) is not allowed to be null if the value has not been previously set.");
        }
        if (endingColor == null) {
            return;
        }
        this.endingColor = endingColor;
        this.endingRed = this.endingColor.getRed();
        this.endingGreen = this.endingColor.getGreen();
        this.endingBlue = this.endingColor.getBlue();
        this.endingAlpha = this.endingColor.getAlpha();
    }

    @Override
    public Paint getItemPaint(int row, int column) {
        if (column == 0) {
            return this.startingColor;
        }
        int columns = this.getColumnCount();
        if (column == columns - 1) {
            return this.endingColor;
        }
        int red = this.startingRed + column * ((this.endingRed - this.startingRed) / --columns);
        int green = this.startingGreen + column * ((this.endingGreen - this.startingGreen) / columns);
        int blue = this.startingBlue + column * ((this.endingBlue - this.startingBlue) / columns);
        int alpha = this.startingAlpha + column * ((this.endingAlpha - this.startingAlpha) / columns);
        return new Color(red, green, blue, alpha);
    }
}

