/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.combobox;

import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.swing.DateField;
import com.jmorgan.swing.calendar.CalendarSelectionListener;
import com.jmorgan.swing.calendar.CalendarUI;
import com.jmorgan.swing.combobox.ComboBoxController;
import com.jmorgan.swing.spinner.DateSpinner;
import java.beans.PropertyChangeListener;
import java.util.Calendar;

public class CalendarComboBoxController
extends ComboBoxController
implements CalendarSelectionListener,
PropertyChangeNotifier {
    private DateSpinner spinner;
    private CalendarUI calendarUI;

    public CalendarComboBoxController() throws ClassNotFoundException {
        this(new DateSpinner(new DateField()), new CalendarUI("com.jmorgan.swing.calendar.panels.SmallDayContainer"));
    }

    public CalendarComboBoxController(DateSpinner attachToComponent, CalendarUI comboComponent) {
        this(attachToComponent, comboComponent, false);
    }

    public CalendarComboBoxController(DateSpinner attachToComponent, CalendarUI comboComponent, boolean allowEditing) {
        super(attachToComponent, comboComponent, allowEditing);
        attachToComponent.setPreferredSize(attachToComponent.getPreferredSize().width, 20);
        this.spinner = attachToComponent;
        this.calendarUI = comboComponent;
        this.calendarUI.addCalendarSelectionListener(this);
        this.setToolTip("Display Calendar");
    }

    @Override
    public void invokeDropDown() {
        Calendar date = ((DateField)this.spinner.getComponent()).getDate();
        if (date == null) {
            date = Calendar.getInstance();
        }
        this.calendarUI.setDate(date);
    }

    @Override
    public void dateSelected(Calendar date) {
        this.setDate(date);
        this.comboItemSelected();
    }

    public Calendar getDate() {
        return ((DateField)this.spinner.getComponent()).getDate();
    }

    public void setDate(Calendar date) {
        ((DateField)this.spinner.getComponent()).setDate(date);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        ((DateField)this.spinner.getComponent()).addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        ((DateField)this.spinner.getComponent()).removePropertyChangeListener(listener);
    }
}

