/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.combobox;

import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.swing.JMColorChooser;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.combobox.ComboBoxController;
import com.jmorgan.swing.event.ChangeEventInvoker;
import java.awt.Color;
import java.beans.PropertyChangeListener;

public class ColorComboBoxController
extends ComboBoxController
implements PropertyChangeNotifier {
    private JMColorChooser colorChooser;
    private JMPanel colorDisplay;
    private PropertyChangeSupport propertyChangeSupport;

    public ColorComboBoxController() {
        this(Color.WHITE);
    }

    public ColorComboBoxController(Color initialColor) {
        this(new JMPanel(), new JMColorChooser(), initialColor);
    }

    public ColorComboBoxController(JMPanel attachToComponent, JMColorChooser comboComponent, Color initialColor) {
        super(attachToComponent, comboComponent);
        this.colorChooser = comboComponent;
        this.colorChooser.removeChooserPanel(0);
        this.colorChooser.removeChooserPanel(2);
        this.colorChooser.removePreviewPanel();
        this.colorDisplay = attachToComponent;
        this.colorDisplay.setPreferredSize(100, 20);
        this.setColor(initialColor);
        new ChangeEventInvoker(this.colorChooser, this, "colorChanged");
        this.setToolTip("Display Color Chooser");
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public Color getColor() {
        return this.colorChooser.getColor();
    }

    public void setColor(Color color) {
        this.colorChooser.setColor(color);
        this.colorDisplay.setBackground(color);
    }

    public void colorChanged() {
        Color color = this.colorChooser.getColor();
        Color oldColor = this.colorDisplay.getBackground();
        this.colorDisplay.setBackground(color);
        this.propertyChangeSupport.firePropertyChange("color", oldColor, color);
    }

    @Override
    public void invokeDropDown() {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

