/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.combobox;

import com.jmorgan.swing.combobox.ComboBox;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class ComboBoxController {
    private Component attachToComponent;
    private Component dropDownComponent;
    private ComboBox comboBox;
    private boolean allowEditing;
    private boolean caseSensitive;
    private String toolTip;
    private Icon dropDownIcon;

    public ComboBoxController(Component attachToComponent, Component dropDownComponent) {
        this(attachToComponent, dropDownComponent, false);
    }

    public ComboBoxController(Component attachToComponent, Component dropDownComponent, boolean allowEditing) {
        this.attachToComponent = attachToComponent;
        this.setAllowEditing(allowEditing);
        this.dropDownComponent = dropDownComponent;
    }

    public abstract void invokeDropDown();

    public Component getAttachToComponent() {
        return this.attachToComponent;
    }

    public Component getDropDownComponent() {
        return this.dropDownComponent;
    }

    public ComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(ComboBox component) {
        this.comboBox = component;
    }

    public void comboItemSelected() {
        this.comboBox.hidePopup();
    }

    public boolean isEditingAllowed() {
        return this.allowEditing;
    }

    public void setAllowEditing(boolean allowEditing) {
        this.allowEditing = allowEditing;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.caseSensitive = isCaseSensitive;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public Icon getDropDownIcon() {
        return this.dropDownIcon;
    }

    public void setDropDownIcon(String iconName) {
        this.setDropDownIcon(new ImageIcon(iconName));
    }

    public void setDropDownIcon(Icon icon) {
        this.dropDownIcon = icon;
    }
}

