/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.combobox;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.combobox.ComboBoxController;
import com.jmorgan.swing.combobox.ComboBoxFormatter;
import com.jmorgan.swing.event.FocusEventInvoker;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.event.MouseEventInvoker;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.StringUtility;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;

public class ListComboBoxController
extends ComboBoxController
implements KeyListener {
    private ComboBoxFormatter componentFormatter;
    private JList list;
    private JTextField field;
    private boolean ignoreListSelectionEvent;

    public ListComboBoxController() {
        this(new JMTextField(), new JMList());
    }

    public ListComboBoxController(JList comboComponent) {
        this(new JMTextField(), comboComponent);
    }

    public ListComboBoxController(JTextField attachToComponent, JList comboComponent) {
        this(attachToComponent, comboComponent, false);
    }

    public ListComboBoxController(JTextField attachToComponent, JList comboComponent, boolean allowEditing) {
        super(attachToComponent, new JMScrollPane(comboComponent), allowEditing);
        Object value;
        this.list = comboComponent;
        this.field = attachToComponent;
        new ListSelectionEventInvoker(this.list, this, "listSelectionChanged");
        new MouseEventInvoker((Object)comboComponent, 1, this, "resetOnMouseClicked");
        new MouseEventInvoker((Object)attachToComponent, 1, this, "resetOnMouseClicked");
        new FocusEventInvoker(this.field, 1, (Object)this, "fieldHasFocus");
        this.field.setEditable(allowEditing);
        this.field.setBackground(UIManager.getColor("TextField.background"));
        if (allowEditing) {
            attachToComponent.addKeyListener(this);
        } else {
            attachToComponent.setDisabledTextColor(UIManager.getColor("TextField.inactiveBackground"));
        }
        if (this.list.getModel().getSize() > 0 && (value = this.list.getSelectedValue()) != null) {
            this.formatValueToComponent(value);
        }
        this.list.addKeyListener(this);
        this.field.addKeyListener(this);
        this.setToolTip("Display Choices");
    }

    public JTextField getField() {
        return this.field;
    }

    public JList getList() {
        return this.list;
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public Object getSelectedValue() {
        return this.list.getSelectedValue();
    }

    public Object getItemAt(int index) {
        return this.list.getModel().getElementAt(index);
    }

    public void setSelectedValue(Object value) {
        this.ignoreListSelectionEvent = true;
        this.list.setSelectedValue(value, true);
        this.formatValueToComponent(value);
        this.setFieldSelection();
    }

    public void setSelectedIndex(int index) {
        this.ignoreListSelectionEvent = true;
        int modelSize = this.list.getModel().getSize();
        if (index < 0 || index >= modelSize) {
            this.list.clearSelection();
            return;
        }
        this.list.setSelectedIndex(index);
        this.formatValueToComponent(this.list.getSelectedValue());
        this.setFieldSelection();
    }

    @Override
    public void setAllowEditing(boolean allowEditing) {
        super.setAllowEditing(allowEditing);
        if (this.field != null) {
            this.field.setEditable(allowEditing);
        }
    }

    private void setFieldSelection() {
        if (this.isEditingAllowed()) {
            this.field.selectAll();
            this.field.setEditable(true);
        } else {
            this.field.select(0, 0);
        }
    }

    public void clearListModel() {
        ListModel listModel = this.list.getModel();
        if (listModel instanceof JMListModel) {
            ((JMListModel)listModel).clear();
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.list.removeListSelectionListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.field.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.field.removePropertyChangeListener(listener);
    }

    @Override
    public void invokeDropDown() {
        String text = this.field.getText().toLowerCase();
        if (!StringUtility.isEmpty(text)) {
            ListModel lm = this.list.getModel();
            int i = 0;
            while (i < lm.getSize()) {
                Object o = lm.getElementAt(i);
                if (o != null && o.toString().toLowerCase().startsWith(text)) {
                    this.list.setSelectedIndex(i);
                    this.list.ensureIndexIsVisible(i);
                    break;
                }
                ++i;
            }
        }
        new AsynchMethodInvoker((Object)this.list, "requestFocus", 100);
    }

    public ComboBoxFormatter getComponentFormatter() {
        return this.componentFormatter;
    }

    public void setComponentFormatter(ComboBoxFormatter componentFormatter) {
        this.componentFormatter = componentFormatter;
    }

    @Reflected
    private void listSelectionChanged() {
        if (this.ignoreListSelectionEvent) {
            this.ignoreListSelectionEvent = false;
            return;
        }
        this.formatValueToComponent(this.list.getSelectedValue());
    }

    public void formatValueToComponent(Object value) {
        if (value == null) {
            return;
        }
        if (this.componentFormatter != null) {
            this.field.setText(this.componentFormatter.formatValueToComponent(this.field, value));
        } else {
            this.field.setText(value.toString());
        }
        this.setFieldSelection();
    }

    @Reflected
    public void fieldHasFocus() {
        if (this.field.getText().trim().length() == 0 && this.list.getModel().getSize() > 0 && !this.getComboBox().isPopupWindowVisible()) {
            new AsynchMethodInvoker((Object)this.getComboBox(), "dropDownButtonClicked", 250);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        Object source = e.getSource();
        if (source == this.list) {
            if (keyCode == 10) {
                this.formatValueToComponent(this.list.getSelectedValue());
                this.comboItemSelected();
            }
            if (keyCode == 27 && this.getComboBox().isPopupWindowVisible()) {
                this.getComboBox().dropDownButtonClicked();
            }
            return;
        }
        switch (keyCode) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return;
            }
            case 40: {
                this.getComboBox().dropDownButtonClicked();
                return;
            }
        }
        new AsynchMethodInvoker((Object)this, "processKeyPress", (Object)keyCode, 100);
    }

    public void processKeyPress(int keyCode) {
        String text = this.field.getSelectedText();
        if (text == null) {
            text = this.field.getText();
        }
        if (text.length() == 0) {
            return;
        }
        text = text.toLowerCase();
        ListModel listModel = this.list.getModel();
        int i = 0;
        while (i < listModel.getSize()) {
            String elementString;
            Object listElement = listModel.getElementAt(i);
            boolean caseSensitive = this.isCaseSensitive();
            String string = elementString = caseSensitive ? listElement.toString() : listElement.toString().toLowerCase();
            if (elementString.startsWith(text)) {
                this.field.setText(listElement.toString());
                int caretPosition = text.length();
                if (keyCode == 8) {
                    --caretPosition;
                }
                this.field.setCaretPosition(caretPosition);
                this.field.moveCaretPosition(elementString.length());
                return;
            }
            ++i;
        }
    }

    @Reflected
    public void resetOnMouseClicked() {
        this.formatValueToComponent(this.list.getSelectedValue());
        this.comboItemSelected();
    }
}

