/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.combobox;

import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.combobox.ListComboBox;
import com.jmorgan.swing.list.ListModelFactory;
import com.jmorgan.util.DateMetaData;
import java.awt.Dimension;
import java.util.Calendar;

public class MonthComboBox
extends ListComboBox {
    public static final int LONGNAMES = 0;
    public static final int SHORTNAMES = 1;
    private JMList list;
    private JMTextField textField;
    private int mode;

    public MonthComboBox() {
        this(0);
    }

    public MonthComboBox(int mode) {
        this.mode = mode;
        this.textField = (JMTextField)this.getField();
        this.list = (JMList)this.getList();
        this.list.setModel(ListModelFactory.createListModel(mode == 0 ? DateMetaData.MONTH_NAMES : DateMetaData.getMonthNames(3)));
        this.list.setPrototypeCellValue("SEPTEMBER");
        this.setPreferredSize(new Dimension(100, 20));
        Calendar c = Calendar.getInstance();
        this.setMonthNumber(c.get(2));
    }

    public int getMonthNumber() {
        return this.list.getSelectedIndex();
    }

    public String getMonthName() {
        return (String)this.list.getSelectedValue();
    }

    public void setMonthNumber(int monthNumber) {
        if (monthNumber < 0) {
            monthNumber = 11;
        }
        if (monthNumber > 11) {
            monthNumber = 0;
        }
        String monthName = (this.mode == 0 ? DateMetaData.MONTH_NAMES : DateMetaData.getMonthNames(3))[monthNumber];
        this.list.setSelectedIndex(monthNumber);
        this.textField.setText(monthName);
    }

    public void setMonth(String month) {
        this.setMonthNumber(DateMetaData.getMonthNumber(month));
    }
}

