/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.component;

import com.jmorgan.swing.ActiveLabel;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;

public class ActiveCheckBox
extends JMPanel {
    private JMCheckBox checkBox;
    private ActiveLabel label;
    private BorderLayout layout = new BorderLayout(5, 0);

    public ActiveCheckBox() {
        this("Add Link Here");
    }

    public ActiveCheckBox(String text) {
        this(text, null, false);
    }

    public ActiveCheckBox(String text, Icon icon) {
        this(text, icon, false);
    }

    public ActiveCheckBox(String text, Icon icon, boolean selected) {
        this.setLayout(this.layout);
        this.checkBox = new JMCheckBox(icon, selected);
        this.checkBox.setSelected(selected);
        this.label = new ActiveLabel(text);
        this.add((Component)this.checkBox, "West");
        this.add((Component)this.label, "Center");
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public void setSelected(boolean state) {
        this.checkBox.setSelected(state);
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public ActiveLabel getLabel() {
        return this.label;
    }

    public Icon getIcon() {
        if (this.checkBox == null) {
            return new ImageIcon();
        }
        return this.checkBox.getIcon();
    }

    public int getIconTextGap() {
        if (this.layout == null) {
            return 5;
        }
        return this.layout.getHgap();
    }

    public String getImageName() {
        if (this.checkBox == null) {
            return "";
        }
        return this.checkBox.getImageName();
    }

    public Icon getPressedIcon() {
        if (this.checkBox == null) {
            return new ImageIcon();
        }
        return this.checkBox.getPressedIcon();
    }

    public Icon getRolloverIcon() {
        if (this.checkBox == null) {
            return new ImageIcon();
        }
        return this.checkBox.getRolloverIcon();
    }

    public Icon getRolloverSelectedIcon() {
        if (this.checkBox == null) {
            return new ImageIcon();
        }
        return this.checkBox.getRolloverSelectedIcon();
    }

    public Icon getSelectedIcon() {
        if (this.checkBox == null) {
            return new ImageIcon();
        }
        return this.checkBox.getSelectedIcon();
    }

    public boolean isRolloverEnabled() {
        if (this.checkBox == null) {
            return false;
        }
        return this.checkBox.isRolloverEnabled();
    }

    public void setIcon(Icon defaultIcon) {
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setIcon(defaultIcon);
    }

    public void setIconTextGap(int iconTextGap) {
        if (this.layout == null) {
            return;
        }
        this.layout.setHgap(iconTextGap);
    }

    public void setImageName(String imageName) {
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setImageName(imageName);
    }

    public void setPressedIcon(Icon pressedIcon) {
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setPressedIcon(pressedIcon);
    }

    public void setRolloverEnabled(boolean b) {
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setRolloverEnabled(b);
    }

    public void setRolloverIcon(Icon rolloverIcon) {
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setRolloverIcon(rolloverIcon);
    }

    public void setRolloverSelectedIcon(Icon rolloverSelectedIcon) {
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setRolloverSelectedIcon(rolloverSelectedIcon);
    }

    public void setSelectedIcon(Icon selectedIcon) {
        if (this.checkBox == null) {
            return;
        }
        this.checkBox.setSelectedIcon(selectedIcon);
    }

    @Override
    public Font getFont() {
        if (this.label == null) {
            return UIManager.getFont("Label.font");
        }
        return this.label.getFont();
    }

    @Override
    public Color getForeground() {
        if (this.label == null) {
            return UIManager.getColor("Label.foreground");
        }
        return this.label.getForeground();
    }

    @Override
    public void setFont(Font font) {
        if (this.label == null) {
            return;
        }
        this.label.setFont(font);
    }

    @Override
    public void setForeground(Color fg) {
        if (this.label == null) {
            return;
        }
        this.label.setForeground(fg);
    }

    public boolean getDrawUnderline() {
        if (this.label == null) {
            return true;
        }
        return this.label.getDrawUnderline();
    }

    public void setDrawUnderline(boolean drawUnderline) {
        if (this.label == null) {
            return;
        }
        this.label.setDrawUnderline(drawUnderline);
    }

    public void addActionListener(ActionListener al) {
        this.label.addActionListener(al);
    }

    public void removeActionListener(ActionListener al) {
        this.label.removeActionListener(al);
    }

    public void addItemListener(ItemListener il) {
        this.checkBox.addItemListener(il);
    }

    public void removeItemListener(ItemListener il) {
        this.checkBox.removeItemListener(il);
    }
}

