/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.component;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.image.ImageUtilities;
import com.jmorgan.lang.MathExt;
import com.jmorgan.swing.JMLayeredPane;
import com.jmorgan.swing.PictureControl;
import com.jmorgan.swing.event.ComponentEventInvoker;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;

public class DialComponent
extends JMLayeredPane
implements PropertyChangeNotifier,
MouseMotionListener,
MouseListener {
    private PictureControl dialArrow;
    private PictureControl dialBackground;
    private Image arrowImage;
    private Image backgroundImage;
    private Point arrowCenter;
    private int size;
    private double halfSize;
    private PropertyChangeSupport propertyChangeSupport;
    private double minimumRange;
    private double maximinRange;
    private double value;

    public DialComponent(String backgroundImageName, String pointerImageName) {
        this(new ImageIcon(backgroundImageName).getImage(), new ImageIcon(pointerImageName).getImage());
    }

    public DialComponent(Image backgroundImage, Image pointerImage) {
        this.setBackgroundImage(backgroundImage);
        this.setName("dial");
        this.size = this.backgroundImage.getWidth(this);
        this.setArrowImage(pointerImage);
        this.arrowCenter = new Point(this.arrowImage.getWidth(this) / 2, this.arrowImage.getHeight(this) / 2);
        this.add((Component)this.dialBackground, new Integer(0));
        this.add((Component)this.dialArrow, new Integer(1));
        this.setMinimumRange(0.0);
        this.setMaximinRange(100.0);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        new ComponentEventInvoker(this, 8, (Object)this, "componentResized");
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void setArrowImage(Image arrowImage) {
        if (this.dialArrow == null) {
            this.dialArrow = new PictureControl(arrowImage);
        } else {
            this.dialArrow.setImage(arrowImage);
        }
        this.arrowImage = arrowImage;
    }

    public void setBackgroundImage(Image backgroundImage) {
        if (this.dialBackground == null) {
            this.dialBackground = new PictureControl(backgroundImage);
        } else {
            this.dialBackground.setImage(backgroundImage);
        }
        this.backgroundImage = backgroundImage;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.setValue(value, true);
    }

    private void setValue(double value, boolean changeImage) {
        if (this.value == value) {
            return;
        }
        double oldValue = this.value;
        this.value = value;
        this.propertyChangeSupport.firePropertyChange(this.getName(), oldValue, this.value);
        if (changeImage) {
            double angle = (this.value - this.minimumRange) / ((this.maximinRange - this.minimumRange) / 360.0);
            this.displayAtAngle(angle);
        }
    }

    public double getMinimumRange() {
        return this.minimumRange;
    }

    public void setMinimumRange(double minimumRange) {
        this.minimumRange = minimumRange;
    }

    public double getMaximinRange() {
        return this.maximinRange;
    }

    public void setMaximinRange(double maximinRange) {
        this.maximinRange = maximinRange;
    }

    private void rotateFromPoint(Point p) {
        double trueDegrees = MathExt.getAngleFromOrigin(new Point((int)this.halfSize, (int)this.halfSize), p);
        this.displayAtAngle(trueDegrees);
        this.setValue((this.maximinRange - this.minimumRange) / 360.0 * trueDegrees + this.minimumRange, false);
    }

    private void displayAtAngle(double angle) {
        Image rotatedImage = ImageUtilities.getRotatedImage(this.arrowImage, angle, new Point(this.arrowCenter));
        this.dialArrow.setImage(rotatedImage);
        this.dialArrow.repaint();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Reflected
    public void componentResized() {
        this.size = this.getSize().width;
        this.halfSize = this.size / 2;
        this.dialArrow.setBounds(0, 0, this.size, this.size);
        this.dialBackground.setBounds(0, 0, this.size, this.size);
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        this.rotateFromPoint(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.rotateFromPoint(e.getPoint());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

