/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.component;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.io.filefilter.FileFilterAdapter;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.component.FileSelectionListener;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.KeyEventInvoker;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;

public class FileSelectorComponent
extends JMPanel {
    private static File startingDirectory;
    private JMButton browseButton;
    private JMButton actionButton;
    private JMTextField fileNameField;
    private JMLabel label;
    private String labelText;
    private String buttonText;
    private FileFilterAdapter fileNameFilter;
    private String fileName;
    private File selectedFile;
    private ArrayList<FileSelectionListener> fileSelectionListeners;

    public FileSelectorComponent() {
        this("&File", "&OK");
    }

    public FileSelectorComponent(String labelText, String buttonText) {
        this(labelText, buttonText, "");
    }

    public FileSelectorComponent(String labelText, String buttonText, String fileName) {
        super(new BorderLayout(5, 5));
        if (startingDirectory == null) {
            startingDirectory = new File(".");
        }
        this.setLabelText(labelText);
        this.setButtonText(buttonText);
        this.setFileName(fileName);
        if (fileName != null) {
            this.selectedFile = new File(fileName);
        }
        this.add((Component)this.getFieldLabel(), "West");
        this.add((Component)this.getField(), "Center");
        FlowLayout flowLayout = new FlowLayout(0, 5, 0);
        JMPanel buttonPanel = new JMPanel(flowLayout);
        buttonPanel.addAll(this.getBrowseButton(), this.getActionButton());
        this.add((Component)buttonPanel, "East");
        this.setPreferredSize(300, 25);
        this.browseButton.setPreferredSize(this.browseButton.getPreferredSize().width, 25);
        this.actionButton.setPreferredSize(this.actionButton.getPreferredSize().width, 25);
        new ActionEventInvoker(this.browseButton, this, "fileOpen");
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
        if (this.label != null) {
            this.label.setText(labelText);
        }
    }

    public JMButton getButton() {
        return this.actionButton;
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
        if (this.actionButton != null) {
            this.actionButton.setText(buttonText);
        }
    }

    public String getFileName() {
        return this.fileNameField.getText();
    }

    public File getStartingDirectory() {
        return startingDirectory;
    }

    public void setStartingDirectory(File startingDirectory) {
        FileSelectorComponent.startingDirectory = startingDirectory;
    }

    public void addFileSelectionListener(FileSelectionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.fileSelectionListeners == null) {
            this.fileSelectionListeners = new ArrayList();
        }
        this.fileSelectionListeners.add(listener);
    }

    public void removeFileSelectionListener(FileSelectionListener listener) {
        if (listener == null) {
            return;
        }
        if (CollectionUtility.isEmpty(this.fileSelectionListeners)) {
            return;
        }
        this.fileSelectionListeners.remove(listener);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        if (this.fileNameField != null) {
            this.fileNameField.setText(fileName);
        }
        if (this.actionButton != null) {
            this.actionButton.setEnabled(true);
        }
    }

    public File getSelectedFile() {
        String fileName = this.getFileName();
        File file = new File(fileName);
        return file;
    }

    public FileFilterAdapter getFileNameFilter() {
        return this.fileNameFilter;
    }

    public void setFileNameFilter(FileFilterAdapter fileNameFilter) {
        this.fileNameFilter = fileNameFilter;
    }

    public JMLabel getFieldLabel() {
        if (this.label == null) {
            this.label = new JMLabel(this.labelText);
        }
        return this.label;
    }

    public JMTextField getField() {
        if (this.fileNameField == null) {
            this.fileNameField = new JMTextField(this.fileName);
            new KeyEventInvoker((Object)this.fileNameField, 1, this, "checkButtonState");
        }
        return this.fileNameField;
    }

    @Reflected
    private void checkButtonState() {
        String fileName = this.fileNameField.getText();
        if (StringUtility.isEmpty(fileName)) {
            this.actionButton.setEnabled(false);
        } else {
            this.actionButton.setEnabled(true);
        }
    }

    public JMButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JMButton("...");
        }
        return this.browseButton;
    }

    public JMButton getActionButton() {
        if (this.actionButton == null) {
            this.actionButton = new JMButton(this.buttonText);
            this.actionButton.setEnabled(false);
        }
        return this.actionButton;
    }

    public void hideActionButton() {
        this.actionButton.setVisible(false);
    }

    public void setActionButtonIcon(Icon icon) {
        this.actionButton.setIcon(icon);
    }

    @Reflected
    private void fileOpen() {
        File selectedFile = GUIServices.fileOpenDialog(startingDirectory.getAbsolutePath(), this.fileNameFilter);
        if (selectedFile == null) {
            return;
        }
        startingDirectory = selectedFile.getParentFile();
        this.fileNameField.setText(selectedFile.getAbsolutePath());
        this.actionButton.setEnabled(true);
        this.selectedFile = selectedFile;
        this.notifyListeners(this.selectedFile);
    }

    private void notifyListeners(File file) {
        if (this.fileSelectionListeners == null) {
            return;
        }
        for (FileSelectionListener fileSelectionListener : this.fileSelectionListeners) {
            fileSelectionListener.fileSelected(this, file);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionButton.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionButton.removeActionListener(actionListener);
    }
}

