/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.component;

import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.util.InsetsFactory;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;

public class MiniCalculator
extends JMPanel
implements PropertyChangeNotifier {
    private static final char ADD = '+';
    private static final char SUBTRACT = '-';
    private static final char MULTIPLY = '*';
    private static final char DIVIDE = '/';
    private static final char SQUARE = '\u00b2';
    private static final char PERCENT = '%';
    private static final char SQUARE_ROOT = '\u221a';
    private static final char NEGATE = '\u00b1';
    private double value;
    private String currentValue;
    private char operator;
    private PropertyChangeSupport propertyChangeSupport;
    private ArrayList<ActionListener> equalsListeners;

    public MiniCalculator() {
        this(0.0);
    }

    public MiniCalculator(double value) {
        super(new GridLayout(5, 5, 5, 5));
        this.setOpaque(true);
        this.setInsets(InsetsFactory.createFixedInsets(5));
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.createCalculatorButtons();
        this.clear();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.equalsListeners = new ArrayList();
    }

    private void createCalculatorButtons() {
        String[] stringArray = new String[25];
        stringArray[3] = "CE";
        stringArray[4] = "C";
        stringArray[5] = "7";
        stringArray[6] = "8";
        stringArray[7] = "9";
        stringArray[8] = "+";
        stringArray[9] = "%";
        stringArray[10] = "4";
        stringArray[11] = "5";
        stringArray[12] = "6";
        stringArray[13] = "-";
        stringArray[14] = "x\u00b2";
        stringArray[15] = "1";
        stringArray[16] = "2";
        stringArray[17] = "3";
        stringArray[18] = "*";
        stringArray[19] = "\u221a";
        stringArray[20] = ".";
        stringArray[21] = "0";
        stringArray[22] = "=";
        stringArray[23] = "/";
        stringArray[24] = "\u00b1";
        String[] labels = stringArray;
        String[] stringArray2 = new String[25];
        stringArray2[3] = "clearError";
        stringArray2[4] = "clear";
        stringArray2[5] = "appendDigit";
        stringArray2[6] = "appendDigit";
        stringArray2[7] = "appendDigit";
        stringArray2[8] = "setOperator";
        stringArray2[9] = "applyOperation";
        stringArray2[10] = "appendDigit";
        stringArray2[11] = "appendDigit";
        stringArray2[12] = "appendDigit";
        stringArray2[13] = "setOperator";
        stringArray2[14] = "applyOperation";
        stringArray2[15] = "appendDigit";
        stringArray2[16] = "appendDigit";
        stringArray2[17] = "appendDigit";
        stringArray2[18] = "setOperator";
        stringArray2[19] = "applyOperation";
        stringArray2[20] = "appendDigit";
        stringArray2[21] = "appendDigit";
        stringArray2[22] = "equalsClicked";
        stringArray2[23] = "setOperator";
        stringArray2[24] = "applyOperation";
        String[] functions = stringArray2;
        char[] cArray = new char[25];
        cArray[5] = 55;
        cArray[6] = 56;
        cArray[7] = 57;
        cArray[8] = 43;
        cArray[9] = 37;
        cArray[10] = 52;
        cArray[11] = 53;
        cArray[12] = 54;
        cArray[13] = 45;
        cArray[14] = 178;
        cArray[15] = 49;
        cArray[16] = 50;
        cArray[17] = 51;
        cArray[18] = 42;
        cArray[19] = 8730;
        cArray[20] = 46;
        cArray[21] = 48;
        cArray[23] = 47;
        cArray[24] = 177;
        char[] args = cArray;
        int i = 0;
        while (i < labels.length) {
            String label = labels[i];
            if (label == null) {
                this.add(new JMPanel());
            } else {
                JMButton button = new JMButton(label);
                if (args[i] == '\u0000') {
                    new ActionEventInvoker(button, this, functions[i]);
                } else {
                    new ActionEventInvoker(button, this, functions[i], Character.valueOf(args[i]));
                }
                this.add(button);
            }
            ++i;
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        double oldValue = this.value;
        this.value = value;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("value", oldValue, this.value);
        }
    }

    private void setCurrentValue(String value) {
        this.currentValue = value;
    }

    public void clearError() {
        this.setCurrentValue("");
    }

    public void clear() {
        this.setValue(0.0);
        this.setCurrentValue("");
        this.setOperator('+');
    }

    public void appendDigit(char digit) {
        this.setCurrentValue(this.currentValue + digit);
    }

    public void setOperator(char operator) {
        if (this.currentValue.length() > 0) {
            this.computeValue();
        }
        this.setCurrentValue("");
        this.operator = operator;
    }

    public void applyOperation(char operator) {
        boolean operateOnCurrent = this.currentValue.length() > 0;
        double current = operateOnCurrent ? Double.parseDouble(this.currentValue) : this.value;
        double result = 0.0;
        switch (operator) {
            case '%': {
                result = current / 100.0;
                break;
            }
            case '\u00b2': {
                result = Math.pow(current, 2.0);
                break;
            }
            case '\u221a': {
                result = Math.sqrt(current);
                break;
            }
            case '\u00b1': {
                result = current *= -1.0;
            }
        }
        if (operateOnCurrent) {
            this.setCurrentValue("" + result);
        } else {
            this.setValue(result);
        }
    }

    public void equalsClicked() {
        this.computeValue();
        ActionEvent event = new ActionEvent(this, 1001, "equalsClicked");
        for (ActionListener listener : this.equalsListeners) {
            listener.actionPerformed(event);
        }
    }

    private void computeValue() {
        if (this.currentValue.length() == 0) {
            this.currentValue = "" + this.value;
        }
        double current = Double.parseDouble(this.currentValue);
        switch (this.operator) {
            case '+': {
                this.setValue(this.value + current);
                break;
            }
            case '-': {
                this.setValue(this.value - current);
                break;
            }
            case '*': {
                this.setValue(this.value * current);
                break;
            }
            case '/': {
                this.setValue(current == 0.0 ? 0.0 : this.value / current);
            }
        }
        this.operator = (char)43;
        this.setCurrentValue("");
    }

    public void addActionListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        this.equalsListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        this.equalsListeners.remove(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
        super.removePropertyChangeListener(listener);
    }
}

