/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.customizer;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.swing.component.NumericalSliderComponent;
import com.jmorgan.swing.customizer.AbstractCustomizer;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import java.awt.Dimension;

public class DimensionCustomizer
extends AbstractCustomizer<Dimension, NumericalSliderComponent[]> {
    private NumericalSliderComponent width = this.getSlider("&Width", 0);
    private NumericalSliderComponent height = this.getSlider("&Height", 0);
    private boolean ignoreChanges;

    public DimensionCustomizer() {
        super(new VerticalFlowLayout(0));
        this.add(this.width);
        this.add(this.height);
        this.ignoreChanges = false;
        this.setEditor(new NumericalSliderComponent[]{this.width, this.height});
    }

    public DimensionCustomizer(Dimension dimension) {
        this();
        this.setDimension(dimension);
    }

    public Dimension getDimension() {
        return (Dimension)this.getObject();
    }

    @Override
    public void setObject(Object bean) {
        this.setDimension((Dimension)bean);
    }

    public void setDimension(Dimension dimension) {
        this.width.setValue(dimension.width);
        this.height.setValue(dimension.height);
        super.setObject(dimension);
    }

    private NumericalSliderComponent getSlider(String label, int value) {
        NumericalSliderComponent c = new NumericalSliderComponent(label, value, 0, 2000, 1);
        c.getLabel().setPreferredSize(50, 23);
        new PropertyChangeInvoker(c, this, "dimensionChanged");
        return c;
    }

    @Reflected
    private void dimensionChanged() {
        if (this.ignoreChanges) {
            return;
        }
        Dimension dimension = new Dimension((Dimension)this.getObject());
        dimension.width = (int)this.width.getValue();
        dimension.height = (int)this.height.getValue();
        this.setObject(dimension);
    }
}

