/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.customizer;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.io.filefilter.GIFFileFilter;
import com.jmorgan.io.filefilter.JPEGFileFilter;
import com.jmorgan.io.filefilter.JPGFileFilter;
import com.jmorgan.io.filefilter.MultiFileFilter;
import com.jmorgan.io.filefilter.PNGFileFilter;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.PictureControl;
import com.jmorgan.swing.customizer.AbstractCustomizer;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.util.GUIServices;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconCustomizer
extends AbstractCustomizer<Icon, PictureControl> {
    private PictureControl iconPainter = new PictureControl();
    private MultiFileFilter iconFileFilter;
    private String iconName;
    private JMButton getIconButton;

    public IconCustomizer() {
        super(new BorderLayout(1, 5));
        this.iconPainter.setPreferredSize(100, 100);
        this.iconPainter.setScaleToControl(false);
        this.add((Component)this.iconPainter, "Center");
        this.getIconButton = new JMButton("&Get Icon...");
        new ActionEventInvoker(this.getIconButton, this, "loadIcon");
        this.add((Component)this.getIconButton, "South");
        this.iconFileFilter = new MultiFileFilter();
        this.iconFileFilter.addFilter(new GIFFileFilter());
        this.iconFileFilter.addFilter(new JPEGFileFilter());
        this.iconFileFilter.addFilter(new JPGFileFilter());
        this.iconFileFilter.addFilter(new PNGFileFilter());
        this.setEditor(this.iconPainter);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getIconButton.setEnabled(enabled);
    }

    public String getIconName() {
        return this.iconName;
    }

    public Icon getIcon() {
        return (Icon)this.getObject();
    }

    @Override
    public void setObject(Object bean) {
        this.setIcon((Icon)bean);
    }

    public void setIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            this.iconPainter.setImage(((ImageIcon)icon).getImage());
        }
        super.setObject(icon);
    }

    @Reflected
    private void loadIcon() {
        File file = GUIServices.fileOpenDialog(".", this.iconFileFilter);
        if (file == null) {
            return;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
        this.iconPainter.setImage(image);
        this.iconPainter.setImageName(file.getAbsolutePath());
        this.iconName = file.getName();
        this.setIcon(new ImageIcon(image));
    }
}

