/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.customizer;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.io.filefilter.GIFFileFilter;
import com.jmorgan.io.filefilter.JPEGFileFilter;
import com.jmorgan.io.filefilter.JPGFileFilter;
import com.jmorgan.io.filefilter.MultiFileFilter;
import com.jmorgan.io.filefilter.PNGFileFilter;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.PictureControl;
import com.jmorgan.swing.customizer.AbstractCustomizer;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.util.GUIServices;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;

public class ImageCustomizer
extends AbstractCustomizer<Image, PictureControl> {
    private PictureControl imagePainter = new PictureControl();
    private MultiFileFilter imageFileFilter;

    public ImageCustomizer() {
        super(new BorderLayout(1, 5));
        this.add((Component)this.imagePainter, "Center");
        JMButton getImageButton = new JMButton("&Get Image...");
        new ActionEventInvoker(getImageButton, this, "loadImage");
        this.add((Component)getImageButton, "South");
        this.imageFileFilter = new MultiFileFilter();
        this.imageFileFilter.addFilter(new GIFFileFilter());
        this.imageFileFilter.addFilter(new JPEGFileFilter());
        this.imageFileFilter.addFilter(new JPGFileFilter());
        this.imageFileFilter.addFilter(new PNGFileFilter());
        this.setEditor(this.imagePainter);
    }

    public Image getImage() {
        return (Image)this.getObject();
    }

    @Override
    public void setObject(Object bean) {
        this.setImage((Image)bean);
    }

    public void setImage(Image image) {
        this.imagePainter.setImage(image);
        super.setObject(image);
    }

    @Reflected
    private void loadImage() {
        File file = GUIServices.fileOpenDialog(".", this.imageFileFilter);
        if (file == null) {
            return;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(file.getAbsolutePath());
        this.imagePainter.setImageName(file.getAbsolutePath());
        this.setImage(image);
    }
}

